
#include <iostream>
#include <fstream>
#include <algorithm>
#include <string>
#include <utility>
#include <iterator>
#include <array>
#include <limits>
#include <vector>
#include <set>
#include <cassert>
#include <cfloat>
#include <list>
#include <cmath>
#include <map>
#include <filesystem>
#include <thread>
#include <mutex>
#include <unordered_set>
#include <unordered_map>
#include <cstring>

using namespace std;

static unsigned char getbyte(FILE *inf)
{
  unsigned char buf[1];
  fread(buf,1,1,inf);
  return buf[0];
}

static unsigned short getshort(FILE *inf)
{
  unsigned char buf[2];
  fread(buf,2,1,inf);
  return (buf[0]<<8)+(buf[1]<<0);
}

static unsigned long getlong(FILE *inf)
{
  unsigned char buf[4];
  fread(buf,4,1,inf);
  return (buf[0]<<24)+(buf[1]<<16)+(buf[2]<<8)+(buf[3]<<0);
}

static void putbyte(FILE *outf, unsigned char x)
{
  unsigned char buf[1] = { x };
  fwrite(buf,1,1,outf);
}

static void putshort(FILE *outf, unsigned short x)
{
  unsigned char buf[2] = { x >> 8, x & 0xffu };
  fwrite(buf,2,1,outf);
}

static void putlong(FILE *outf, unsigned long x)
{
  unsigned char buf[4] = { x >> 24, (x >> 16) & 0xffu , (x >> 8) & 0xffu, x & 0xffu  };
  fwrite(buf,4,1,outf);
}

// https://media.xiph.org/svt/SGIIMAGESPEC

void writeRGBAFile(FILE *const out, int w, int h, unsigned char* pixels)
{
    putshort(out, 474); // magic
    putbyte (out,   0); // storage
    putbyte (out,   1); // bpc
    putshort(out,   3); // dimensions
    putshort(out,   w); // xsize
    putshort(out,   h); // ysize
    putshort(out,   3); // zsize
    putlong (out,   0); // pixmin
    putlong (out,   0xffffff); // pixmax
    putlong (out,   0); // dummy
    char name[80] = { 0 };
    fwrite(name, 1, 80, out);
    putlong (out,   0); // colormap ID
    char dummy2[404];
    memset(dummy2, 0, sizeof(dummy2));
    fwrite(dummy2, 1, 404, out);

    unsigned char* pixels2 = (unsigned char*)malloc(w * h * 3);
    // re-interleave
    for(int y = 0; y < h; ++y)
    {
        for(int x = 0; x < w; ++x)
        {
            for(int z = 0; z < 3; ++z)
            {
                pixels2[(x + y * w) + z * w * h] = pixels[z + (x + (h - 1 - y) * w) * 3];
            }
        }
    }

    fwrite(pixels2, 1, w * h * 3, out);
    
    free(pixels2);
}

static void setCrumb(uint8_t* buffer, int pos, int crumb)
{
    assert(crumb >= 0 && crumb < 4);
    buffer[(pos / 8) * 2 + 0] |= (crumb & 1) << (7 - (pos & 7));
    buffer[(pos / 8) * 2 + 1] |= (crumb >> 1) << (7 - (pos & 7));
}

static int getCrumb(const uint8_t* buffer, int pos)
{
    int crumb = 0;
    crumb = ((buffer[(pos / 8) * 2 + 0] >> (7 - (pos & 7))) & 1) |
             (((buffer[(pos / 8) * 2 + 1] >> (7 - (pos & 7))) & 1) << 1);
    assert(crumb >= 0 && crumb < 4);
    return crumb;
}

static void writeBytesToFile(const char* filename, const vector<uint8_t>& bytes)
{
    FILE* out = fopen(filename, "wb");
    assert(out);
    fwrite(bytes.data(), 1, bytes.size(), out);
    fclose(out);
}

static void setPixel(uint8_t* buffer, int w, int h, int x, int y, int col)
{
    assert(x >= 0 && x < w);
    assert(y >= 0 && y < h);
    const int tile_x = x / 8, tile_y = y / 8;
    assert(tile_x < (w / 8));
    const int tile_index = tile_x + tile_y * (w / 8);
    setCrumb(buffer, tile_index * 64 + (x & 7) + (y & 7) * 8, col);
}

static int getPixel(const uint8_t* buffer, int w, int h, int x, int y)
{
    const int tile_x = x / 8, tile_y = y / 8;
    const int tile_index = tile_x + tile_y * (w / 8);
    return getCrumb(buffer, tile_index * 64 + (x & 7) + (y & 7) * 8);
}


static const char cube_image[16 * 16 + 1] = 
        "11111111" "        "
        "11111111" "2       "
        "11111111" "22      "
        "11111111" "222     "
        "11111111" "2222    "
        "11111111" "22222   "
        "11111111" "222222  "
        "11111111" "2222222 "
        "33333333" "22222222"
        " 3333333" "32222222"
        "  333333" "33222222"
        "   33333" "33322222"
        "    3333" "33332222"
        "     333" "33333222"
        "      33" "33333322"
        "       3" "33333332"
    ;


const int in_image_w = 284, in_image_h = 10;
uint8_t* image = NULL;

int main(int argc, char** argv)
{
    FILE* in = fopen("megafont.ppm", "r");
    fseek(in, 60, SEEK_SET);
    image = (uint8_t*)malloc(in_image_w * in_image_h * 3);
    fread(image, 1, in_image_w * in_image_h * 3, in);
    fclose(in);

    vector<uint8_t> tiledata;
    vector<uint8_t> tilemap;

    const uint8_t tile_index_base = 0x00; // 0xA0;

    //const string message = "  POCKET TANGRAMS ";
    const string message = "POCKET TANGRAMS ";

    //for(int source_char_index = 0; source_char_index < 26; ++source_char_index)
    for(size_t j = 0; j < message.length(); ++j)
    {
        const uint32_t testimage_w = 80, testimage_h = 80;
        const uint32_t num_testimage_bytes = testimage_w * testimage_h * 3;
        uint8_t* testimage = (uint8_t*)malloc(num_testimage_bytes);
        memset(testimage, 0, num_testimage_bytes);

        if(message[j] == ' ')
        {
        }
        else
        {
            const int source_char_index = message[j] - 'A';
            assert(source_char_index >= 0 && source_char_index < 26);

            const int source_x = source_char_index * 11, source_y = 0;

            for(int y = 0; y < 9; ++y)
                for(int x = 0; x < 9; ++x)
                {
                    int p = image[((x + source_x) + (y + source_y) * in_image_w) * 3 + 0];
                    if(p == 0)
                        for(int v = 0; v < 16; ++v)
                            for(int u = 0; u < 16; ++u)
                            {
                                char c = cube_image[u + v * 16];
                                int col = (c == '1') ? 255 : (c == '2') ? 128 : (c == '3') ? 64 : 0;
                                if(col)
                                {
                                    int ix = x * 8 + u, iy = y * 8 + v;
                                    if(ix >= 0 && iy >= 0 && ix < testimage_w && iy < testimage_h)
                                        for(int i = 0; i < 3; ++i)
                                            testimage[(ix + iy * testimage_w) * 3 + i] = col;
                                }
                            }
                }
        }
/*
        if(source_char_index == 2)
        {
            FILE* out = fopen("megascoller_test.rgba", "wb");
            writeRGBAFile(out, testimage_w, testimage_h, testimage);
            fclose(out);
        }
*/

        for(int y = 0; y < testimage_h; y += 16)
        {
            for(int x0 = 0; x0 < testimage_w; x0 += 8)
            {
                const int x = testimage_w - 8 - x0;

                vector<uint8_t> tile_pair(32, 0);

                for(int u = 0; u < 8; ++u)
                    for(int v = 0; v < 16; ++v)
                    {
                        uint8_t c = testimage[((x + u) + (y + v) * testimage_w) * 3 + 0];
                        int crumb = (c == 255) ? 1 : (c == 128) ? 2 : (c == 64) ? 3 : 0;
                        setPixel(tile_pair.data(), 8, 16, u, v, crumb);
                    }

                uint8_t tile_index;

                bool found = false;
    #if 1
                for(size_t i = 0; i < tiledata.size(); i += 32)
                {
                    if(equal(tile_pair.begin(), tile_pair.end(), tiledata.begin() + i))
                    {
                        tile_index = i / 16;
                        found = true;
                        break;
                    }
                }
    #endif

                if(!found)
                {
                    tile_index = tiledata.size() / 16;
                    tiledata.insert(tiledata.end(), tile_pair.begin(), tile_pair.end());
                }

                tilemap.push_back(tile_index_base + tile_index);
            }

            tilemap.insert(tilemap.end(), 6, 0x00);
        }

        free(testimage);
    }

    const int num_tiles = (tiledata.size() / 16);

    cout << "tilemap.size() = " << tilemap.size() << endl;
    cout << "tiledata.size() = " << tiledata.size() << endl;
    cout << "num tiles = " << num_tiles << endl;

    cout << "RLE compressing..." << endl;

    vector<uint8_t> tilemap_compressed;

    assert(num_tiles <= 64);

    int run_length = 1;
    for(int i = 0; i < tilemap.size(); ++i)
    {
        uint8_t next = (i == (tilemap.size() - 1)) ? 0xff : tilemap[i + 1];
        if(tilemap[i] != next || run_length == 4)
        {
            tilemap_compressed.push_back(tilemap[i] | ((run_length - 1) << 6));
            run_length = 1;
            continue;
        }
        ++run_length;
    }

    tilemap_compressed.push_back(0xff);

    cout << "tilemap_compressed.size() = " << tilemap_compressed.size() << endl;

    writeBytesToFile("logo_tiledata.bin", tiledata);
    writeBytesToFile("logo_tilemap.bin", tilemap);
    writeBytesToFile("logo_tilemap_compressed.bin", tilemap_compressed);

    cout << "done." << endl;
}
