
#include <iostream>
#include <fstream>
#include <algorithm>
#include <string>
#include <utility>
#include <iterator>
#include <array>
#include <limits>
#include <vector>
#include <set>
#include <cassert>
#include <cfloat>
#include <list>
#include <cmath>
#include <map>
#include <filesystem>
#include <thread>
#include <mutex>
#include <unordered_set>
#include <unordered_map>
#include <cstring>

using namespace std;


static void setCrumb(uint8_t* buffer, int pos, int crumb)
{
    assert(crumb >= 0 && crumb < 4);
    buffer[(pos / 8) * 2 + 0] |= (crumb & 1) << (7 - (pos & 7));
    buffer[(pos / 8) * 2 + 1] |= (crumb >> 1) << (7 - (pos & 7));
}

static int getCrumb(const uint8_t* buffer, int pos)
{
    int crumb = 0;
    crumb = ((buffer[(pos / 8) * 2 + 0] >> (7 - (pos & 7))) & 1) |
             (((buffer[(pos / 8) * 2 + 1] >> (7 - (pos & 7))) & 1) << 1);
    assert(crumb >= 0 && crumb < 4);
    return crumb;
}

static void writeBytesToFile(const char* filename, const vector<uint8_t>& bytes)
{
    FILE* out = fopen(filename, "wb");
    assert(out);
    fwrite(bytes.data(), 1, bytes.size(), out);
    fclose(out);
}

static void setPixel(uint8_t* buffer, int w, int h, int x, int y, int col)
{
    assert(x >= 0 && x < w);
    assert(y >= 0 && y < h);
    const int tile_x = x / 8, tile_y = y / 8;
    assert(tile_x < (w / 8));
    const int tile_index = tile_x + tile_y * (w / 8);
    setCrumb(buffer, tile_index * 64 + (x & 7) + (y & 7) * 8, col);
}

static int getPixel(const uint8_t* buffer, int w, int h, int x, int y)
{
    const int tile_x = x / 8, tile_y = y / 8;
    const int tile_index = tile_x + tile_y * (w / 8);
    return getCrumb(buffer, tile_index * 64 + (x & 7) + (y & 7) * 8);
}


const int in_image_w = 80, in_image_h = 80;
uint8_t* image = NULL;

int main(int argc, char** argv)
{
    FILE* in = fopen("title.ppm", "r");
    fseek(in, 59, SEEK_SET);
    image = (uint8_t*)malloc(in_image_w * in_image_h * 3);
    fread(image, 1, in_image_w * in_image_h * 3, in);
    fclose(in);

    vector<uint8_t> tiledata;
    vector<uint8_t> tilemap;

    const uint8_t tile_index_base = 0xA0;

    for(int y = 0; y < in_image_h; y += 16)
    {
        for(int x0 = 0; x0 < in_image_w; x0 += 8)
        {
            const int x = in_image_w - 8 - x0;

            vector<uint8_t> tile_pair(32, 0);

            for(int u = 0; u < 8; ++u)
                for(int v = 0; v < 16; ++v)
                {
                    uint8_t c = image[((x + u) + (y + v) * in_image_w) * 3 + 0];
                    int crumb = 0;
                    if(c == 0xDF)
                    {
                        crumb = 0b00;
                    }
                    else
                    {
                        crumb = 1 + 2 - (int)std::max(0.0, std::min(2.0, double(c) * 2.0 / 255.0));
                    }
                    setPixel(tile_pair.data(), 8, 16, u, v, crumb);
                }

            uint8_t tile_index;

            bool found = false;
#if 1
            for(size_t i = 0; i < tiledata.size(); i += 32)
            {
                if(equal(tile_pair.begin(), tile_pair.end(), tiledata.begin() + i))
                {
                    tile_index = i / 16;
                    found = true;
                    break;
                }
            }
#endif

            if(!found)
            {
                tile_index = tiledata.size() / 16;
                tiledata.insert(tiledata.end(), tile_pair.begin(), tile_pair.end());
            }

            tilemap.push_back(tile_index_base + tile_index);
        }

        tilemap.insert(tilemap.end(), 6, 0x00);
    }

    assert(tilemap.size() == 16 * 5);

    cout << "tiledata.size() = " << tiledata.size() << endl;
    cout << "num tiles = " << (tiledata.size() / 16) << endl;

    writeBytesToFile("logo_tiledata.bin", tiledata);
    writeBytesToFile("logo_tilemap.bin", tilemap);

    cout << "done." << endl;
}
