
#include <iostream>
#include <fstream>
#include <algorithm>
#include <string>
#include <utility>
#include <iterator>
#include <array>
#include <limits>
#include <vector>
#include <set>
#include <cassert>
#include <cfloat>
#include <list>
#include <cmath>
#include <map>
#include <filesystem>
#include <thread>
#include <mutex>
#include <unordered_set>
#include <unordered_map>
#include <cstring>

using namespace std;

static const int num_chars = 10;

/*
static const char digits_display[8 * 8 + 1] = 
        " 11111  "
        "2     7 "
        "2     7 "
        " 44444  "
        "3     6 "
        "3     6 "
        " 55555  "
        "        "
    ;
*/

static const char digits_display[8 * 8 + 1] = 
        " 1111   "
        "2    7  "
        "2    7  "
        " 4444   "
        "3    6  "
        "3    6  "
        " 5555   "
        "        "
    ;

static const char colon_symbol[8 * 8 + 1] = 
        "        "
        "        "
        "   1    "
        "        "
        "        "
        "   1    "
        "        "
        "        "
    ;

static const char arrow_symbol[8 * 8 + 1] = 
        "   X    "
        "   XX   "
        "XXXXXX  "
        "XXXXXXX "
        "XXXXXX  "
        "   XX   "
        "   X    "
        "        "
    ;

static const char reticle_symbol[8 * 8 + 1] = 
        "   X    "
        "        "
        "   X    "
        "X XXX X "
        "   X    "
        "        "
        "   X    "
        "        "
    ;

static const char blank_symbol[8 * 8 + 1] = 
        "XXXXX   "
        "XXXXX   "
        "XXXXX   "
        "XXXXX   "
        "XXXXX   "
        "XXXXX   "
        "XXXXX   "
        "XXXXX   "
    ;

static const char opaque_symbol[8 * 8 + 1] = 
        "XXXXXXXX"
        "XXXXXXXX"
        "XXXXXXXX"
        "XXXXXXXX"
        "XXXXXXXX"
        "XXXXXXXX"
        "XXXXXXXX"
        "XXXXXXXX"
    ;

static const char* digits[num_chars] = {
     /* 0 */   "127365",
     /* 1 */   "76",
     /* 2 */   "17435",
     /* 3 */   "17465",
     /* 4 */   "2746",
     /* 5 */   "12465",
     /* 6 */   "124365",
     /* 7 */   "176",
     /* 8 */   "1234567",
     /* 9 */   "127465",
    };


int main(int argc, char** argv)
{
    uint32_t outbytes = (num_chars + 5) * 8; // 1bpp, one byte for char width
    uint8_t* bin = (uint8_t*)malloc(outbytes);
    memset(bin, 0, outbytes);

    for(int i = 0; i < num_chars; ++i)
    {
        const char* digit = digits[i];
        uint8_t* tile = bin + i * 8;
        for(int v = 0; v < 8; ++v)
            for(int u = 0; u < 8; ++u)
            {
                const char p = digits_display[u + v * 8];

                for(const char* c = digit; *c; ++c)
                {
                    if(*c == p)
                    {
                        tile[v] |= 1u << (7 - u);
                        break;
                    }
                }
            }
    }

    {
        uint8_t* tile = bin + (num_chars + 0) * 8;
        for(int v = 0; v < 8; ++v)
            for(int u = 0; u < 8; ++u)
            {
                const char p = colon_symbol[u + v * 8];

                if(p != ' ')
                    tile[v] |= 1u << (7 - u);
            }
    }

    {
        uint8_t* tile = bin + (num_chars + 1) * 8;
        for(int v = 0; v < 8; ++v)
            for(int u = 0; u < 8; ++u)
            {
                const char p = arrow_symbol[u + v * 8];

                if(p != ' ')
                    tile[v] |= 1u << (7 - u);
            }
    }

    {
        uint8_t* tile = bin + (num_chars + 2) * 8;
        for(int v = 0; v < 8; ++v)
            for(int u = 0; u < 8; ++u)
            {
                const char p = reticle_symbol[u + v * 8];

                if(p != ' ')
                    tile[v] |= 1u << (7 - u);
            }
    }

    {
        uint8_t* tile = bin + (num_chars + 3) * 8;
        for(int v = 0; v < 8; ++v)
            for(int u = 0; u < 8; ++u)
            {
                const char p = blank_symbol[u + v * 8];

                if(p != ' ')
                    tile[v] |= 1u << (7 - u);
            }
    }

    {
        uint8_t* tile = bin + (num_chars + 4) * 8;
        for(int v = 0; v < 8; ++v)
            for(int u = 0; u < 8; ++u)
            {
                const char p = opaque_symbol[u + v * 8];

                if(p != ' ')
                    tile[v] |= 1u << (7 - u);
            }
    }

    FILE* out = fopen("digits.bin", "wb");
    fwrite(bin, 1, outbytes, out);
    fclose(out);
}
