SECTION "HBlankHandler", ROM0
HBlankHandler:
    ; Write sprite Y position
    ld [hli], a
    inc l
    ld a, b
    ; Write sprite tile index
    ld [hl], a

    ; Do the stuff for the background
    ;ldh a, [TitleScreen_RasterScrollY]
    ;dec a
    ;ldh [rSCY], a
    ;ldh a, [TitleScreen_RasterPalette]
    ;ldh [rBGP], a

    ldh a, [rLY]
    ld d, a
    ld h, HIGH(CheckerboardSineTable)
    ld l, a
    ldh a, [TitleScreen_SineOffset]
    add a, l
    ld l, a
    ld a, d
    cpl
    ld b, a
    ld a, [hl] ; Depth
    ld c, a
    add a, b
    ldh [rSCY], a
    ;ldh [TitleScreen_RasterScrollY], a
    ld a, d
    and a, 1
    ld b, a

    ld hl, CheckerboardPalettetable
assert LOW(CheckerboardPalettetable) == 0
    ld a, e     ; 1
    and a, 128  ; 2
    add a, c    ; 1
    rlca        ; 1
    rlca        ; 1
    add a, b    ; 1
    add a, l    ; 1
    ld l, a     ; 1


    ld a, [hl] ; Palette
    ldh [rBGP], a
    ;ldh [TitleScreen_RasterPalette], a
    ld hl, CheckerboardUStepTable
    ld a, c
    add a, l
    ld l, a
    ld a, [hl]
    add a, e
    ld e, a


    ld a, d
    cp a, 128
    jr nz, :++
    ld a, IEF_VBLANK
    ldh [rIE], a
REPT 8
;    nop
ENDR
    ld a, INGAME_MENU_BG_PALETTE
    ldh [rBGP], a
    ld a, 2
    ldh [rSCY], a
    ldh a, [TitleScreen_FrameCounter]
    ldh [rSCX], a
    SetLCDControl LCDCF_ON | LCDCF_BGON | LCDCF_BG8000 | LCDCF_BG9800 | LCDCF_OBJOFF | LCDCF_OBJ16 | LCDCF_WINOFF
    ;push af
    ;push hl
    ;push bc
    ;push de
    call _hUGE_dosound
    ;pop de
    ;pop bc
    ;pop hl
    ;pop af

    call readJoypad
    bit GB_JOY_BIT_START, a
    jr z, :+
    ; Fake my own RETI
    xor a, a
    ldh [rIF], a
    ei
    pop hl
    jp TangramSelectionScreen
:

    reti
:



    ; Do the stuff for the vertical megascroller

    ldh a, [TitleScreen_MegaScrollSubPos]
    cpl
    inc a
    ld c, a
    dec a
    cpl
    add a, d
    ld d, a

assert LOW(MegaScrollerMapBuffer) == 0
    ld h, HIGH(MegaScrollerMapBuffer)
    ldh a, [TitleScreen_MegaScrollPos]
    add a, d
    ld l, a
    ld a, [hl]
    ld b, a

    ; Calculate sprite address in OAM
    ld a, d
    and a, 31
    rlca
    rlca
    ld l, a
    ; Calculate sprite Y position
    ld a, d
    and a, $F0

    add a, 16 + 16
    add a, c

    ld h, $FE
    reti