
#include <iostream>
#include <fstream>
#include <algorithm>
#include <string>
#include <utility>
#include <iterator>
#include <array>
#include <limits>
#include <vector>
#include <set>
#include <cassert>
#include <cfloat>
#include <list>
#include <cmath>
#include <map>
#include <filesystem>
#include <thread>
#include <mutex>
#include <unordered_set>
#include <unordered_map>
#include <cstring>

using namespace std;

static const int max_chars = 128;

int char_offsets[max_chars][2];
int char_sizes[max_chars][2];
int num_chars = 0;
const int in_image_w = 560, in_image_h = 9;
uint8_t* image = NULL;

static unsigned char getbyte(FILE *inf)
{
  unsigned char buf[1];
  fread(buf,1,1,inf);
  return buf[0];
}

static unsigned short getshort(FILE *inf)
{
  unsigned char buf[2];
  fread(buf,2,1,inf);
  return (buf[0]<<8)+(buf[1]<<0);
}

static unsigned long getlong(FILE *inf)
{
  unsigned char buf[4];
  fread(buf,4,1,inf);
  return (buf[0]<<24)+(buf[1]<<16)+(buf[2]<<8)+(buf[3]<<0);
}

static void putbyte(FILE *outf, unsigned char x)
{
  unsigned char buf[1] = { x };
  fwrite(buf,1,1,outf);
}

static void putshort(FILE *outf, unsigned short x)
{
  unsigned char buf[2] = { x >> 8, x & 0xffu };
  fwrite(buf,2,1,outf);
}

static void putlong(FILE *outf, unsigned long x)
{
  unsigned char buf[4] = { x >> 24, (x >> 16) & 0xffu , (x >> 8) & 0xffu, x & 0xffu  };
  fwrite(buf,4,1,outf);
}

// https://media.xiph.org/svt/SGIIMAGESPEC

void writeRGBAFile(FILE *const out, int w, int h, unsigned char* pixels)
{
    putshort(out, 474); // magic
    putbyte (out,   0); // storage
    putbyte (out,   1); // bpc
    putshort(out,   3); // dimensions
    putshort(out,   w); // xsize
    putshort(out,   h); // ysize
    putshort(out,   3); // zsize
    putlong (out,   0); // pixmin
    putlong (out,   0xffffff); // pixmax
    putlong (out,   0); // dummy
    char name[80] = { 0 };
    fwrite(name, 1, 80, out);
    putlong (out,   0); // colormap ID
    char dummy2[404];
    memset(dummy2, 0, sizeof(dummy2));
    fwrite(dummy2, 1, 404, out);

    unsigned char* pixels2 = (unsigned char*)malloc(w * h * 3);
    // re-interleave
    for(int y = 0; y < h; ++y)
    {
        for(int x = 0; x < w; ++x)
        {
            for(int z = 0; z < 3; ++z)
            {
                pixels2[(x + y * w) + z * w * h] = pixels[z + (x + (h - 1 - y) * w) * 3];
            }
        }
    }

    fwrite(pixels2, 1, w * h * 3, out);
    
    free(pixels2);
}

static void drawText(unsigned char* pixels, int w, int h, int ox, int oy, const char* str)
{
    const int orig_ox = ox;
    for(const char* c = str; *c; ++c)
    {
        if(*c > 32 && (*c - 32) < 128)
        {
            const int i = *c - 31;
            for(int v = 0; v < char_sizes[i][1]; ++v)
                for(int u = 0; u < char_sizes[i][0]; ++u)
                {
                    int ix = u + char_offsets[i][0];
                    int iy = v + char_offsets[i][1];
                    uint8_t c = image[(ix + iy * in_image_w) * 3 + 0];
                    if(c == 0x00)
                    {
                        assert(u < 8);
                        assert(v < 8);
                        if((ox + u) >= 0 && (ox + u) < w && (oy + v) >= 0 && (oy + v) < h)
                        {
                            pixels[(ox + u + (oy + v) * w) * 3 + 0] = 255;
                            pixels[(ox + u + (oy + v) * w) * 3 + 1] = 255;
                            pixels[(ox + u + (oy + v) * w) * 3 + 2] = 255;
                        }
                    }
                    else if(c == 0xCD)
                    {
                    }
                    else
                        assert(false);
                }
            ox += char_sizes[i][0];
        }
        else if(*c == 32)
            ox += 3;
        else if(*c == '\n')
        {
            ox = orig_ox;
            oy += 8;
        }
    }
}

int main(int argc, char** argv)
{
    FILE* in = fopen("NeoSans.ppm", "r");
    fseek(in, 59, SEEK_SET);
    image = (uint8_t*)malloc(in_image_w * in_image_h * 3);
    fread(image, 1, in_image_w * in_image_h * 3, in);
    fclose(in);


    for(int y = 0; y < in_image_h && num_chars < max_chars; ++y)
        for(int x = 0; x < in_image_w; ++x)
        {
            uint8_t c = image[(x + y * in_image_w) * 3 + 0];
            if(c == 0x00)
            {
            }
            else if(c == 0xCD)
            {
            }
            else if(c == 0x46)
            {
                if(num_chars > 0)
                {
                    char_sizes[num_chars - 1][0] = x - char_offsets[num_chars - 1][0];
                    char_sizes[num_chars - 1][1] = 8;
                }
                char_offsets[num_chars][0] = x + 1;
                char_offsets[num_chars][1] = y + 1;
                assert(y == 0);
                ++num_chars;
                if(num_chars == max_chars)
                    break;
            }
            else
                assert(false);
        }

    assert(num_chars > 0);
    char_sizes[num_chars - 1][0] = in_image_w - char_offsets[num_chars - 1][0];
    char_sizes[num_chars - 1][1] = 8;


    for(int i = 0; i < num_chars; ++i)
    {
        cout << char_offsets[i][0] << ", " << char_offsets[i][1] << ", " << char_sizes[i][0] << ", " << char_sizes[i][1] << endl;
    }


    uint32_t outbytes = num_chars * 8 + num_chars; // 1bpp, one byte for char width
    uint8_t* bin = (uint8_t*)malloc(outbytes);
    memset(bin, 0, outbytes);
    uint8_t* widths = (uint8_t*)malloc(num_chars);
    memset(widths, 0, num_chars);

    for(int i = 0; i < num_chars; ++i)
    {
        uint8_t* charbytes = bin + i * 8;
        for(int v = 0; v < char_sizes[i][1]; ++v)
            for(int u = 0; u < char_sizes[i][0]; ++u)
            {
                int x = u + char_offsets[i][0];
                int y = v + char_offsets[i][1];
                uint8_t c = image[(x + y * in_image_w) * 3 + 0];
                if(c == 0x00)
                {
                    assert(u < 8);
                    assert(v < 8);
                    charbytes[v] |= 1u << (7 - u);
                }
                else if(c == 0xCD)
                {
                }
                else
                    assert(false);
            }
        assert(char_sizes[i][0] <= 8);
        assert(char_sizes[i][1] == 8);
        widths[i] = char_sizes[i][0];
    }

    {
        FILE* out = fopen("neosans.bin", "wb");
        fwrite(bin, 1, outbytes, out);
        fclose(out);
    }

    {
        FILE* out = fopen("neosans_widths.bin", "wb");
        fwrite(widths, 1, num_chars, out);
        fclose(out);
    }

    cout << "num_chars = " << num_chars << endl;


    const uint32_t testimage_w = 160, testimage_h = 144;
    const uint32_t num_testimage_bytes = testimage_w * testimage_h * 3;
    uint8_t* testimage = (uint8_t*)malloc(num_testimage_bytes);
    memset(testimage, 0, num_testimage_bytes);

    drawText(testimage, testimage_w, testimage_h, testimage_w/2 - 20, testimage_h/2-3*8,
        "Resume\n"
        "Check\n"
        "Solve current\n"
        "Solve all\n"
        "Restart\n"
        "Quit\n"
    );

    drawText(testimage, testimage_w, testimage_h, 0, 0,
        "#001: Cat II"
    );
 
    drawText(testimage, testimage_w, testimage_h, testimage_w - 25, testimage_h - 8,
        "03:21"
    );

    {
        FILE* out = fopen("font_test.rgba", "wb");
        writeRGBAFile(out, testimage_w, testimage_h, testimage);
        fclose(out);
    }

}
