
#include <iostream>
#include <fstream>
#include <algorithm>
#include <string>
#include <utility>
#include <iterator>
#include <array>
#include <limits>
#include <vector>
#include <set>
#include <cassert>
#include <cfloat>
#include <list>
#include <cmath>
#include <map>
#include <filesystem>
#include <thread>
#include <mutex>
#include <unordered_set>
#include <unordered_map>
#include <cstring>

using namespace std;

const double tray_size = 63.0 / 1.25;
const double pts[10][2] = { /* 0 */ { 0, 0 }, /* 1 */ { tray_size, 0 }, /* 2 */ { (tray_size * 3) / 4, (tray_size * 1) / 4 },
                           /* 3 */ { (tray_size * 1) / 2, (tray_size * 1) / 2 }, /* 4 */ { tray_size, (tray_size * 1) / 2 },
                           /* 5 */ { (tray_size * 3) / 4, (tray_size * 3) / 4 }, /* 6 */ { (tray_size * 1) / 4, (tray_size * 3) / 4 },
                           /* 7 */ { 0, tray_size },  /* 8 */ { (tray_size * 2) / 4, tray_size }, /* 9 */ { tray_size, tray_size } };

const int32_t polys[] = {   0, 1, 3, -1,        // 3    0   Type 1, Large Triangle
                            0, 3, 7, -1,        // 3    4   Type 1, Large Triangle
                            1, 4, 2, -1,        // 3    8   Type 2, Small Triangle
                            2, 4, 5, 3, -1,     // 4    12  Type 3, Square
                            3, 5, 6, -1,        // 3    17  Type 2, Small Triangle
                            7, 6, 5, 8, -1,     // 4    21  Type 5, Parallelogram
                            4, 9, 8, -1 };      // 3    26  Type 4, Mid Triangle


void makeRotations(const char* filename, int32_t offset)
{
    double verts[4][2];

    int32_t num_verts = 0;
    while(polys[offset] != -1)
    {
        assert(num_verts < 4);
        verts[num_verts][0] = pts[polys[offset]][0];
        verts[num_verts][1] = pts[polys[offset]][1];
        ++offset;
        ++num_verts;
    }

    double hotspot[2] = { 0.0, 0.0 };

    for(int i = 0; i < num_verts; ++i)
    {
        hotspot[0] += verts[i][0];
        hotspot[1] += verts[i][1];
    }

    hotspot[0] /= double(num_verts);
    hotspot[1] /= double(num_verts);

    for(int i = 0; i < num_verts; ++i)
    {
        verts[i][0] -= hotspot[0];
        verts[i][1] -= hotspot[1];
    }

    const int angle_increments = 128;
    const int num_rotations = !strcmp(filename, "rotations3.bin") ? 32 : !strcmp(filename, "rotations5.bin") ? 64 : 128;
    const int outbytes = num_rotations * num_verts * 2;
    char* outdata = (char*)malloc(outbytes);

    cout << filename << ": " << num_verts << endl;

    int x_min = +128, y_min = +128, x_max = -128, y_max = -128;

    for(int r = 0; r < num_rotations; ++r)
    {
        char* d = outdata + r * num_verts * 2;
        const double th = double(r) / double(angle_increments) * 3.14159265358979323 * 2.0;
        const double c = std::cos(th), s = std::sin(th);
        for(int i = 0; i < num_verts; ++i)
        {
            const double x = verts[i][0], y = verts[i][1];
            assert(x > -64.0 && x < +64.0);
            assert(y > -64.0 && y < +64.0);
            d[i * 2 + 0] = c * y + s * x;
            d[i * 2 + 1] = s * y - c * x;

            x_min = std::min(x_min, int(d[i * 2 + 0]));
            y_min = std::min(y_min, int(d[i * 2 + 1]));
            x_max = std::max(x_max, int(d[i * 2 + 0]));
            y_max = std::max(y_max, int(d[i * 2 + 1]));
        }
    }

    cout << "filename = " << filename << endl;
    cout << "x_min = " << x_min << endl;
    cout << "y_min = " << y_min << endl;
    cout << "x_max = " << x_max << endl;
    cout << "y_max = " << y_max << endl;
    cout << "bounds = " << (0 - x_min + 0) << ", " << (0 - y_min + 0) << ", " <<
                           (127 - x_max - 0) << ", " << (127 - y_max - 0) << endl;

    FILE* out = fopen(filename, "wb");
    fwrite(outdata, 1, outbytes, out);
    fclose(out);
}

int main(int argc, char** argv)
{
    makeRotations("rotations0.bin", 0);
    //makeRotations("rotations1.bin", 4);
    makeRotations("rotations2.bin", 8);
    makeRotations("rotations3.bin", 12);
    //makeRotations("rotations4.bin", 17);
    makeRotations("rotations5.bin", 21);
    makeRotations("rotations6.bin", 26);
}
