
#include <iostream>
#include <fstream>
#include <algorithm>
#include <string>
#include <utility>
#include <iterator>
#include <array>
#include <limits>
#include <vector>
#include <set>
#include <cassert>
#include <cfloat>
#include <cmath>
#include <filesystem>
#include <cstring>

using namespace std;

static const int max_chars = 128;

int char_offsets[max_chars][2];
int char_sizes[max_chars][2];
int num_chars = 0;
const int in_image_w = 560, in_image_h = 9;
uint8_t* image = NULL;


const vector<string> menu_strings = {
        "Resume",
        "Check if solved",
        "Select Tangram",
        "Solve this piece",
        "Solve all pieces",
        "Quit to title screen"
    };

static const int tiles_available = 63;


static void drawText(unsigned char* pixels, int w, int h, int ox, int oy, const char* str)
{
    const int orig_ox = ox;
    for(const char* c = str; *c; ++c)
    {
        if(*c > 32 && (*c - 32) < 128)
        {
            const int i = *c - 31;
            for(int v = 0; v < char_sizes[i][1]; ++v)
                for(int u = 0; u < char_sizes[i][0]; ++u)
                {
                    int ix = u + char_offsets[i][0];
                    int iy = v + char_offsets[i][1];
                    uint8_t c = image[(ix + iy * in_image_w) * 3 + 0];
                    if(c == 0x00)
                    {
                        assert(u < 8);
                        assert(v < 8);
                        if((ox + u) >= 0 && (ox + u) < w && (oy + v) >= 0 && (oy + v) < h)
                        {
                            pixels[(ox + u + (oy + v) * w) * 3 + 0] = 255;
                            pixels[(ox + u + (oy + v) * w) * 3 + 1] = 255;
                            pixels[(ox + u + (oy + v) * w) * 3 + 2] = 255;
                        }
                    }
                    else if(c == 0xCD)
                    {
                    }
                    else
                        assert(false);
                }
            ox += char_sizes[i][0];
        }
        else if(*c == 32)
            ox += 3;
        else if(*c == '\n')
        {
            ox = orig_ox;
            oy += 8;
        }
    }
}


static void loadFont()
{
    FILE* in = fopen("NeoSans.ppm", "r");
    fseek(in, 59, SEEK_SET);
    image = (uint8_t*)malloc(in_image_w * in_image_h * 3);
    fread(image, 1, in_image_w * in_image_h * 3, in);
    fclose(in);

    for(int y = 0; y < in_image_h && num_chars < max_chars; ++y)
        for(int x = 0; x < in_image_w; ++x)
        {
            uint8_t c = image[(x + y * in_image_w) * 3 + 0];
            if(c == 0x00)
            {
            }
            else if(c == 0xCD)
            {
            }
            else if(c == 0x46)
            {
                if(num_chars > 0)
                {
                    char_sizes[num_chars - 1][0] = x - char_offsets[num_chars - 1][0];
                    char_sizes[num_chars - 1][1] = 8;
                }
                char_offsets[num_chars][0] = x + 1;
                char_offsets[num_chars][1] = y + 1;
                assert(y == 0);
                ++num_chars;
                if(num_chars == max_chars)
                    break;
            }
            else
                assert(false);
        }

    assert(num_chars > 0);
    char_sizes[num_chars - 1][0] = in_image_w - char_offsets[num_chars - 1][0];
    char_sizes[num_chars - 1][1] = 8;


    for(int i = 0; i < num_chars; ++i)
    {
        cout << char_offsets[i][0] << ", " << char_offsets[i][1] << ", " << char_sizes[i][0] << ", " << char_sizes[i][1] << endl;
    }
}

int main(int argc, char** argv)
{
    loadFont();

    //uint16_t map_address = 0x9C83;
    uint16_t map_address = 0x9C95 + 64;
    uint16_t tiles_address = 0x8000;
    uint8_t tile_index = 0x08;

    int tiles_used = 0;

    for(size_t i = 0; i < menu_strings.size(); ++i)
    {
        fprintf(stdout, "    ; %s\n", menu_strings[i].c_str());
        uint16_t sub_map_address = map_address;
        fprintf(stdout, "DrawTextFixed TextTilesBuffer + 1, TextStrings_%d\n", (int)i);
        int j = 0, k = 0;
        int orig_tile_index = tile_index;
        int tile_pixel_offset = 0;
        const int len = strlen(menu_strings[i].c_str()) + 1;
        //for(const char* c = menu_strings[i].c_str(); *c; ++c, ++j)
        for(int string_index = 0; string_index < len; ++string_index)
        {
            const char* c = menu_strings[i].c_str() + string_index;
            if(*c)
            {
                int code = *c - 31;
                assert(code >= 0 && code < num_chars);

                int w = char_sizes[code][0];
                tile_pixel_offset += w;
            }
            if(tile_pixel_offset >= 8 || (!*c && tile_pixel_offset > 0))
            {
                tile_pixel_offset -= 8;
                if((tile_index & 0x0F) == 0x0F)
                {
                    int n = tile_index - orig_tile_index + 1;
                    assert(n <= 8);
                    fprintf(stdout, "CopyTilesFixedStride2 $%04X + 1, TextTilesBuffer + 1 + $%02X, %d\n", tiles_address + orig_tile_index * 16, k * 16, n);
                    fprintf(stdout, "CallIotaMem $%04X, $%02X, %d\n", sub_map_address, orig_tile_index, n);
                    sub_map_address += n;
                    tile_index += 8;
                    k += n;
                    orig_tile_index = tile_index + 1;
                }
                ++tile_index;
                tiles_used++;
                assert(tiles_used <= tiles_available);
            }
        }
        if(tile_index != orig_tile_index)
        {
            int n = tile_index - orig_tile_index;
            assert(n <= 8);
            fprintf(stdout, "CopyTilesFixedStride2 $%04X + 1, TextTilesBuffer + 1 + $%02X, %d\n", tiles_address + orig_tile_index * 16, k * 16, n);
            fprintf(stdout, "CallIotaMem $%04X, $%02X, %d\n", sub_map_address, orig_tile_index, n);
            sub_map_address += n;
        }
        map_address += 32;
    }

    fprintf(stdout, "\n\n");
    for(size_t i = 0; i < menu_strings.size(); ++i)
    {
        fprintf(stdout, "TextStrings_%d:\n", (int)i);
        fprintf(stdout, "    db \"%s\", 0\n", menu_strings[i].c_str());
    }
}
