
#include <iostream>
#include <fstream>
#include <algorithm>
#include <string>
#include <utility>
#include <iterator>
#include <array>
#include <limits>
#include <vector>
#include <set>
#include <cassert>
#include <cfloat>
#include <list>
#include <cmath>
#include <map>
#include <filesystem>
#include <thread>
#include <mutex>
#include <unordered_set>
#include <unordered_map>
#include <cstring>

using namespace std;

int main(int argc, char** argv)
{
    FILE* in = fopen(argv[1], "r");
    fseek(in, 60, SEEK_SET);
    uint8_t* image = (uint8_t*)malloc(128 * 32 * 3);
    fread(image, 1, 128 * 32 * 3, in);
    fclose(in);

    uint32_t outbytes = 128 * 2 * 32 / 8;
    uint8_t* bin = (uint8_t*)malloc(outbytes);
    memset(bin, 0, outbytes);

    for(int y = 0; y < 32; ++y)
        for(int x = 0; x < 128; ++x)
        {
            int map_x = x / 8;
            int map_y = y / 8;
            int tile_x = 7 - (x & 7);
            int tile_y = y & 7;

            int c = image[(x + y * 128) * 3];
            int o;
            switch(c)
            {
                case 223:
                    o = 0b00;
                    break;
                case 190:
                    o = 0b11;
                    break;
                case 97:
                    o = 0b10;
                    break;
                case 43:
                    o = 0b01;
                    break;
                default:
                    assert(0);
                    break;
            }
            if(o & 1)
                bin[(map_x + map_y * 16) * 16 + tile_y * 2 + 0] |= 1u << tile_x;
            if(o & 2)
                bin[(map_x + map_y * 16) * 16 + tile_y * 2 + 1] |= 1u << tile_x;
        }


    FILE* out = fopen(argv[2], "wb");
    fwrite(bin, 1, outbytes, out);
    fclose(out);
}
