
#include <iostream>
#include <fstream>
#include <algorithm>
#include <string>
#include <utility>
#include <iterator>
#include <array>
#include <limits>
#include <vector>
#include <set>
#include <cassert>
#include <cfloat>
#include <list>
#include <cmath>
#include <map>
#include <filesystem>
#include <thread>
#include <mutex>
#include <unordered_set>
#include <unordered_map>
#include <cstring>

using namespace std;

struct PieceData
{
    using db = uint8_t;
    using dw = uint16_t;
    union
    {
    struct
    {
//MACRO PieceData
//    db \1 ; ActiveMask
      db ActiveMask;
//    db \2 ; X
      db X;
//    db \3 ; Y
      db Y;
//    db \4 ; Angle
      db Angle;
//    dw \5 ; Vertices
      dw Vertices;
//    dw \6 ; FGDraw
      dw FGDraw;
//    dw \7 ; BGDraw
      dw BGDraw;
//    ds 16 - Piece_SIZEOF
//ENDM
    };
    db dummy[16];
    };
};

static_assert(sizeof(PieceData) == 16, "");

uint8_t* getFileData(const char* filename)
{
    FILE* in = fopen(filename, "r");
    assert(in);
    fseek(in, 0, SEEK_END);
    const uint64_t dat_size = ftell(in);
    cout << "dat_size = " << dat_size << endl;
    assert(dat_size == 65536);
    fseek(in, 0, SEEK_SET);
    uint8_t* dat = (uint8_t*)malloc(dat_size);
    fread(dat, 1, dat_size, in);
    fclose(in);
    return dat;
}

static bool run(const char* dump_filename, const char* bin_filename, const char* inc_filename, const char* name)
{
    cout << "dump_filename = " << dump_filename << endl;
    cout << "bin_filename = " << bin_filename << endl;
    cout << "inc_filename = " << inc_filename << endl;

    const uint8_t* dump = getFileData(dump_filename);

    const int num_pieces = 7;
    const int bytes_per_piece = 16;
    const int piece_coords_address = 0xc200;

    const int outbytes = num_pieces * bytes_per_piece;

    uint8_t* bin = (uint8_t*)malloc(outbytes);

    memcpy(bin, dump + piece_coords_address, outbytes);

    cout << "outbytes = " << outbytes << endl;

    FILE* out = fopen(bin_filename, "wb");
    fwrite(bin, 1, outbytes, out);
    fclose(out);

    PieceData* pieces = (PieceData*)bin;

    char namebytes[16];

    for(int i = 0; i < 16; ++i)
        namebytes[i] = 0;

    const int len = strlen(name);
    assert(len < 16);

    for(int i = 0; i < len; ++i)
        namebytes[i] = (name[i] == '_') ? ' ' : name[i];


    uint8_t box[4] = { 255, 255, 0, 0 };
    for(int i = 0; i < 7; ++i)
    {
        box[0] = std::min(box[0], pieces[i].X);
        box[1] = std::min(box[1], pieces[i].Y);
        box[2] = std::max(box[2], pieces[i].X);
        box[3] = std::max(box[3], pieces[i].Y);
    }
    
    const int center[2] = { (box[0] + box[2] + 1) / 2, (box[1] + box[3] + 1) / 2 };

    int fix_offset_X = 0, fix_offset_Y = 0;

    if(!strcmp(name, "Cat_V"))
    {
        fix_offset_X = 5;
    }
    else if(!strcmp(name, "Horse"))
    {
        fix_offset_X = 2;
    }
    else if(!strcmp(name, "Pipe"))
    {
        fix_offset_X = 4;
    }
    else if(!strcmp(name, "Polar_Bear"))
    {
        fix_offset_X = 2;
    }
    else if(!strcmp(name, "Shoe_II"))
    {
        fix_offset_X = 8;
    }


    if(fix_offset_X != 0 || fix_offset_Y != 0)
        cout << "applying position fix!" << endl;

    for(int i = 0; i < 7; ++i)
    {
        pieces[i].X += 64 - center[0] + fix_offset_X;
        pieces[i].Y += 64 - center[1] + fix_offset_Y;
    }

    {
        uint8_t box[4] = { 255, 255, 0, 0 };

        for(int i = 0; i < 7; ++i)
        {
            box[0] = std::min(box[0], pieces[i].X);
            box[1] = std::min(box[1], pieces[i].Y);
            box[2] = std::max(box[2], pieces[i].X);
            box[3] = std::max(box[3], pieces[i].Y);
        }

        cout << "box = { " << (int)box[0] << ", " << (int)box[1] << ", " << (int)box[2] << ", " << (int)box[3] << "}" << endl;

        const bool m0 = box[0] < 33;
        const bool m1 = box[1] < 33;
        const bool m2 = box[2] >= (128 - 33);
        const bool m3 = box[3] >= (128 - 33);

        const int num_out_x = (m0 ? 1 : 0) + (m2 ? 1 : 0);
        const int num_out_y = (m1 ? 1 : 0) + (m3 ? 1 : 0);

        //if(num_out_x >= 2 || num_out_y >= 2)
        //    return false;
    }


/*
    {
        FILE* out = fopen(inc_filename, "w");
        fprintf(out, "    PieceData %11111110, %d, %d, %d, VertexRotations0, FGDrawPolygon_3, BGDrawPolygon_3 ; Large Triangle 1\n", pieces[0].X, pieces[0].Y, pieces[0].Angle);
        fprintf(out, "    PieceData %11111101, %d, %d, %d, VertexRotations0, FGDrawPolygon_3, BGDrawPolygon_3 ; Large Triangle 2\n", pieces[1].X, pieces[1].Y, pieces[1].Angle);
        fprintf(out, "    PieceData %11111011, %d, %d, %d, VertexRotations1, FGDrawPolygon_3, BGDrawPolygon_3 ; Small Triangle 1\n", pieces[2].X, pieces[2].Y, pieces[2].Angle);
        fprintf(out, "    PieceData %11110111, %d, %d, %d, VertexRotations2, FGDrawPolygon_4, BGDrawPolygon_4 ; Square\n",           pieces[3].X, pieces[3].Y, pieces[3].Angle);
        fprintf(out, "    PieceData %11101111, %d, %d, %d, VertexRotations1, FGDrawPolygon_3, BGDrawPolygon_3 ; Small Triangle 2\n", pieces[4].X, pieces[4].Y, pieces[4].Angle);
        fprintf(out, "    PieceData %11011111, %d, %d, %d, VertexRotations3, FGDrawPolygon_4, BGDrawPolygon_4 ; Parallelogram\n",    pieces[5].X, pieces[5].Y, pieces[5].Angle);
        fprintf(out, "    PieceData %10111111, %d, %d, %d, VertexRotations4, FGDrawPolygon_3, BGDrawPolygon_3 ; Mid Triangle\n",     pieces[6].X, pieces[6].Y, pieces[6].Angle);
        fclose(out);
    }
*/

    {
        FILE* out = fopen(inc_filename, "w");
        fprintf(out, "    db %d, %d, %d ; Large Triangle 1\n", pieces[0].X, pieces[0].Y, pieces[0].Angle);
        fprintf(out, "    db %d, %d, %d ; Large Triangle 2\n", pieces[1].X, pieces[1].Y, pieces[1].Angle);
        fprintf(out, "    db %d, %d, %d ; Small Triangle 1\n", pieces[2].X, pieces[2].Y, pieces[2].Angle);
        fprintf(out, "    db %d, %d, %d ; Square\n",           pieces[3].X, pieces[3].Y, pieces[3].Angle);
        fprintf(out, "    db %d, %d, %d ; Small Triangle 2\n", pieces[4].X, pieces[4].Y, pieces[4].Angle);
        fprintf(out, "    db %d, %d, %d ; Parallelogram\n",    pieces[5].X, pieces[5].Y, pieces[5].Angle);
        fprintf(out, "    db %d, %d, %d ; Mid Triangle\n",     pieces[6].X, pieces[6].Y, pieces[6].Angle);

#if 0
        fprintf(out, "    db \"%s\", ",  namebytes);
        for(int i = len; i < 16; ++i)
            fprintf(out, (i == 15) ? "0" : "0, ");
        fprintf(out, "\n");
#else
        fprintf(out, "    db \"%s\", 0\n",  namebytes);
#endif

        fclose(out);
    }

    return true;
}

int main(int argc, char** argv)
{
    vector<string> incs;
    vector<string> names;

    int num_found = 0;
    int num_emitted = 0;

    for(auto const& dir_entry : filesystem::directory_iterator{"./dumps/"})
    {
        if(dir_entry.is_regular_file() && (dir_entry.path().extension().string() == ".dump"))
        {
            const string name = dir_entry.path().stem().string();
            string dump_filename = dir_entry.path().string();
            string bin_filename = string("tangrams/") + name + ".bin";
            string inc_filename = string("tangrams/") + name + ".inc";
            ++num_found;
            if(run(dump_filename.c_str(), bin_filename.c_str(), inc_filename.c_str(), name.c_str()))
            {
                incs.push_back(inc_filename);
                names.push_back(name);
            }
        }
    }
    {
        FILE* out = fopen("tangrams.inc", "w");
        size_t i = 0;
        for(const string& s : incs)
        {
            fprintf(out, "Tangram_%s:\nINCLUDE \"%s\"\n", names[i].c_str(), s.c_str());
            ++i;
        }
        fprintf(out, "TangramAddressTable:\n");
        for(const string& s : names)
        {
            fprintf(out, "    dw Tangram_%s\n", s.c_str());
            ++num_emitted;
        }
        fclose(out);
    }

    cout << num_found << " dumps found." << endl;
    cout << num_emitted << " tangrams emitted." << endl;
}
