; Input:  Address of first char in text string : hl
;         Address of first tile in VRAM        : de
SECTION "DrawText", ROM0
DrawText:
    StoreWordToAddress DrawText_SourceAddr, hl
    StoreWordToAddress DrawText_DestAddr, de

    ld a, 8 ; Number of rows
.row
    ldh [DrawText_RowCount], a
    ld b, a
    LoadWordFromAddress hl, DrawText_SourceAddr
    push hl
    LoadWordFromAddress de, DrawText_DestAddr
    ld a, e     ; 1
    dec b       ; 1
    sla b       ; 2
    add a, b    ; 1
    ld e, a     ; 1

    xor a, a
    ldh [DrawText_PixelColumn], a ; Pixel column offset
    ld [de], a

.col
    ; Read next character from text string
    pop hl      ; 3
    ld a, [hl+] ; 2
    or a, a
    ; If character code is $00 then this is the end of the string
    jp z, .rowdone
    sub a, 31   ; 2
    push hl     ; 4

    ; Get pixel-width of character
    ld b, a                     ; 1
    ld hl, FontTileWidths       ; 3
    add a, l                    ; 1
    ld l, a                     ; 1
    ld a, [hl]                  ; 2
    ldh [DrawText_CharWidth], a ; 3
    ld c, a                     ; 1
    ld a, b                     ; 1

assert LOW(FontTiles) == 0
    ld h, HIGH(FontTiles)

    rlca       ; 1
    rlca       ; 1
    rlca       ; 1
    ld b, a
    and a, $F8
    ld l, a

    ld a, b
    and a, $07
    add a, h
    ld h, a

    ldh a, [DrawText_RowCount]
    dec a
    add a, l
    ld l, a

    ; Get one 8-pixel row from source tile
    ld a, [hl]
    ld b, a

    ld a, c ; Character width

    ; Get character pixels mask
assert (PixelMaskLUT & $7) == 0
    ld hl, PixelMaskLUT
    dec a       ; 1
    add a, l    ; 1
    ld l, a     ; 1
    ld a, [hl]  ; 2
    ld c, a     ; 1

    ldh a, [DrawText_PixelColumn]
    cpl         ; 1
    add a, 8    ; 2     ; a = 7 - position
    add a, a    ; 1
    add a, a    ; 1
DEF SHIFTLOOP_HEAD_SIZE EQU 3 + 1 + 1 + 1 + 1
DEF SHIFTLOOP_BODY_SIZE EQU 7 * 4
.shiftloop_base
    ld hl, @ + SHIFTLOOP_HEAD_SIZE
    add a, l
    ld l, a
    ld a, b
    jp hl
.shiftloop_body
assert HIGH(@ + SHIFTLOOP_BODY_SIZE) == HIGH(@)
REPT 7
    rrca        ; 1
    srl c       ; 2
    nop         ; 1
ENDR
.shiftloop_end
assert (.shiftloop_base + SHIFTLOOP_HEAD_SIZE) == .shiftloop_body
assert (.shiftloop_base + SHIFTLOOP_HEAD_SIZE + SHIFTLOOP_BODY_SIZE) == .shiftloop_end

    jr c, :++
    ; No carry - character does not span tiles

    ld h, d
    ld l, e
    or a, [hl]
    ld [hl], a

    ; Advance pixel column offset by character width
    ldh a, [DrawText_CharWidth]
    ld b, a
    ldh a, [DrawText_PixelColumn]  ; 3
    add a, b            ; 1
    and a, 7
    ldh [DrawText_PixelColumn], a  ; 3

    jr nz, :+
    ; Advance write address by 16 bytes (assume no carry!)
    swap e      ; 2
    inc e       ; 1
    swap e      ; 2
    xor a, a
    ld [de], a
:

    jr .col
:
    ; Carry - character spans across 2 tiles

    ld b, a
    and a, c

    ld h, d
    ld l, e
    or a, [hl]
    ld [hl], a

    ; Advance write address by 16 bytes (assume no carry!)
    swap e      ; 2
    inc e       ; 1
    swap e      ; 2

    ld a, c     ; 1
    cpl         ; 1
    ld c, a     ; 1
    ld a, b     ; 1
    and a, c    ; 1

    ld [de], a

    ; Advance pixel column offset by character width
    ldh a, [DrawText_CharWidth]
    ld b, a
    ldh a, [DrawText_PixelColumn]  ; 3
    add a, b            ; 1
    and a, 7
    ldh [DrawText_PixelColumn], a  ; 3

    jp .col
.rowdone

    ldh a, [DrawText_RowCount]
    dec a
    jp nz, .row

    ret