MACRO ActionState
AS_\1:

IF STRCMP("\2", "__") != 0
    ld a, b
    or a, c
    ld hl, AS_\2
    jr z, .action
ENDC

    ld hl, AS_\1

    ; Calculate mask of non-self-referring state transitions
EVENT_MASK = 0
FOR I, 3, _NARG+1
J = I - 3
IF STRCMP("\<I>", "__") != 0
EVENT_MASK = EVENT_MASK | (1 << J)
ENDC
ENDR


    ld a, c
    and a, LOW(EVENT_MASK)
    ld c, a
    ld a, b
    and a, HIGH(EVENT_MASK)
    ld b, a


FOR I, 3, _NARG+1
;J = 15 - (I - 3) ; Reverse order so that A and B button presses have higher priority.
J = I - 3
K = 3 + J

IF STRCMP("\<K>", "__") != 0

/*
    ld a, (1 << (J & 7)) ; 2B
    and a, b             ; 1B
    jr z, :+             ; 2B
    ld hl, AS_\<K>       ; 3B
    jr .action           ; 2B
:
*/


    ; Test for event flag
IF J < 8
    bit J, c            ; 2B
ELSE
    bit J - 8, b        ; 2B
ENDC



    jr z, :+            ; 2B


    ; Clear event flag
IF J < 8
    res J, c            ; 2B
ELSE
    res J - 8, b        ; 2B
ENDC


    ;call ClearActionStateEventFlag.clearflag_{d:J} ; 3B
    
    ld hl, AS_\<K>      ; 3B
    jr .action          ; 2B
:
ENDC


ENDR

.action
    push bc
    push hl
    ld de, ActionStateReturnAddress
    push de
ENDM