#include <math.h>
#include <assert.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#include "defs.h"
#include "mem.h"
#include "render.h"
#include "game.h"
#include "input.h"

void resetLevel(player_t* player, gamestate_t* gs, uint32_t start_time)
{
  printf("level reset.\n");
  
  memset(gs, 0, sizeof(gamestate_t));
  memset(player, 0, sizeof(player_t));
  
  gs->num_mines = 0;
  gs->num_pieces = 0;
  gs->num_pieces_collected = 0;
  gs->level_timer = 100;
  gs->current_time_score = 0;
  gs->next_frame = 0;
  gs->play_time = 0;
  gs->timedout = FALSE;
  gs->mine_spawn_interval = 2000;
  gs->next_mine_spawn_time = 500;

  player->x = FRAME_WIDTH / 2;
  player->y = FRAME_HEIGHT / 2;
  player->x_vel = 0.0f;
  player->y_vel = 0.0f;
  player->measured_speed = 0.0f;
  player->destroyed = FALSE;
  
  gs->start_level_time = start_time;
}


void advanceGameFrame(renderstate_t* rs, player_t* player, gamestate_t* gs)
{

}
