#ifndef __DEFS_H__
#define __DEFS_H__

#define STR_MAX               512
#define MEM_HUNK_SIZE         (8 * 1024 * 1024)
#define HUD_MARGIN            10
#define HUD_FONT_W            6
#define HUD_FONT_H            12
#define PLAYER_SIZE           10
#define MAX_MINES             512
#define MAX_BULLETS           512
#define MAX_PIECES            512
#define TEXTURE_TILE_SIZE     32

#define VIRTUAL_FRAME_WIDTH   256
#define VIRTUAL_FRAME_HEIGHT  212 // Mode B3

#define VIRTUAL_PIXEL_WIDTH   1
#define VIRTUAL_PIXEL_HEIGHT  1

#define FRAME_ZOOM_FACTOR     3

#define FRAME_WIDTH           (VIRTUAL_FRAME_WIDTH  * VIRTUAL_PIXEL_WIDTH  * FRAME_ZOOM_FACTOR)
#define FRAME_HEIGHT          (VIRTUAL_FRAME_HEIGHT * VIRTUAL_PIXEL_HEIGHT * FRAME_ZOOM_FACTOR)

#define VIRTUAL_FRAME_ASPECT_RATIO (((double)VIRTUAL_FRAME_WIDTH * (double)VIRTUAL_PIXEL_WIDTH) / ((double)VIRTUAL_FRAME_HEIGHT * (double)VIRTUAL_PIXEL_HEIGHT))


#define TRUE   1
#define FALSE  0

#define MIN(a,b)                ((a) < (b) ? (a) : (b))
#define MAX(a,b)                ((a) > (b) ? (a) : (b))
#define SIGN(a)                 (((a) < 0) ? -1 : +1)
#define SWAP(t, a, b)           { t tmp = (a); (a) = (b); (b) = tmp; }

typedef int bool_t;
typedef uint8_t uchar;
typedef uint16_t ushort;
typedef uint32_t uint;
typedef float Real;

#endif // __DEFS_H__