/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import java.util.List;
import nl.grauw.glass.Line;
import nl.grauw.glass.ParameterScope;
import nl.grauw.glass.Scope;
import nl.grauw.glass.Source;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.Empty;
import nl.grauw.glass.instructions.InstructionFactory;
import nl.grauw.glass.instructions.InstructionObject;

public class Irp
extends InstructionFactory {
    private final Source source;

    public Irp(Source source) {
        this.source = source;
    }

    @Override
    public void expand(Line line, List<Line> lines) {
        Expression arguments = line.getArguments();
        if (arguments == null || !Schema.IDENTIFIER.check(arguments.getHead())) {
            throw new ArgumentException();
        }
        super.expand(line, lines);
        Expression parameter = arguments.getHead();
        int i = 0;
        while ((arguments = arguments.getTail()) != null) {
            ParameterScope parameterScope = new ParameterScope(line.getScope(), parameter, arguments.getHead());
            line.getScope().addSymbol(Integer.toString(i), parameterScope);
            Line rept = line.copy(parameterScope);
            rept.setInstruction(Empty.INSTANCE);
            lines.add(rept);
            Source sourceCopy = this.source.copy(parameterScope);
            sourceCopy.register();
            sourceCopy.expand(lines);
            ++i;
        }
    }

    @Override
    public InstructionObject createObject(Scope context, Expression arguments) {
        return new Empty.EmptyObject(context);
    }
}

