/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Add;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Type;
import nl.grauw.glass.instructions.ArgumentException;

public abstract class InstructionObject {
    protected final Scope context;

    public InstructionObject(Scope context) {
        this.context = context;
    }

    public Expression resolve(Expression address) {
        this.context.setAddress(address);
        return new Add(this.getSize(), address).get(Type.INTEGER);
    }

    public abstract Expression getSize();

    public abstract byte[] getBytes();

    public Expression indexifyDirect(Register register, Expression size) {
        return register.isIndex() ? new Add(IntegerLiteral.ONE, size) : size;
    }

    public Expression indexifyIndirect(Register register, Expression size) {
        return register.isIndex() ? (register.isPair() ? new Add(IntegerLiteral.TWO, size) : new Add(IntegerLiteral.ONE, size)) : size;
    }

    public byte[] indexifyDirect(Register register, byte byte1) {
        if (!register.isIndex()) {
            return new byte[]{byte1};
        }
        if (register.isPair() && register.getIndexOffset().getInteger() != 0) {
            throw new ArgumentException("Can not have index offset for direct addressing.");
        }
        return new byte[]{register.getIndexCode(), byte1};
    }

    public byte[] indexifyDirect(Register register, byte byte1, byte byte2) {
        if (!register.isIndex()) {
            return new byte[]{byte1, byte2};
        }
        if (register.isPair() && register.getIndexOffset().getInteger() != 0) {
            throw new ArgumentException("Can not have index offset for direct addressing.");
        }
        return new byte[]{register.getIndexCode(), byte1, byte2};
    }

    public byte[] indexifyDirect(Register register, byte byte1, byte byte2, byte byte3) {
        if (!register.isIndex()) {
            return new byte[]{byte1, byte2, byte3};
        }
        if (register.isPair() && register.getIndexOffset().getInteger() != 0) {
            throw new ArgumentException("Can not have index offset for direct addressing.");
        }
        return new byte[]{register.getIndexCode(), byte1, byte2, byte3};
    }

    public byte[] indexifyIndirect(Register register, byte byte1) {
        if (!register.isIndex()) {
            return new byte[]{byte1};
        }
        if (!register.isPair()) {
            return this.indexifyDirect(register, byte1);
        }
        int offset = register.getIndexOffset().getInteger();
        if (offset < -128 || offset > 127) {
            throw new ArgumentException("Index offset out of range: " + offset);
        }
        return new byte[]{register.getIndexCode(), byte1, (byte)offset};
    }

    public byte[] indexifyIndirect(Register register, byte byte1, byte byte2) {
        if (!register.isIndex()) {
            return new byte[]{byte1, byte2};
        }
        if (!register.isPair()) {
            return this.indexifyDirect(register, byte1, byte2);
        }
        int offset = register.getIndexOffset().getInteger();
        if (offset < -128 || offset > 127) {
            throw new ArgumentException("Index offset out of range: " + offset);
        }
        return new byte[]{register.getIndexCode(), byte1, (byte)offset, byte2};
    }

    public byte[] indexifyOnlyIndirect(Register register, byte byte1, byte byte2) {
        if (!register.isIndex()) {
            return new byte[]{byte1, byte2};
        }
        if (!register.isPair()) {
            throw new ArgumentException();
        }
        int offset = register.getIndexOffset().getInteger();
        if (offset < -128 || offset > 127) {
            throw new ArgumentException("Index offset out of range: " + offset);
        }
        return new byte[]{register.getIndexCode(), byte1, (byte)offset, byte2};
    }
}

