/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.InstructionFactory;
import nl.grauw.glass.instructions.InstructionObject;

public class Inc
extends InstructionFactory {
    @Override
    public InstructionObject createObject(Scope context, Expression arguments) {
        if (Inc_R.ARGUMENTS.check(arguments)) {
            return new Inc_R(context, arguments.getElement(0));
        }
        if (Inc_RR.ARGUMENTS.check(arguments)) {
            return new Inc_RR(context, arguments.getElement(0));
        }
        throw new ArgumentException();
    }

    public static class Inc_R
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_R_INDIRECT_HL_IX_IY);
        private Expression argument;

        public Inc_R(Scope context, Expression arguments) {
            super(context);
            this.argument = arguments;
        }

        @Override
        public Expression getSize() {
            return this.indexifyIndirect(this.argument.getRegister(), IntegerLiteral.ONE);
        }

        @Override
        public byte[] getBytes() {
            Register register = this.argument.getRegister();
            return this.indexifyIndirect(register, (byte)(4 | register.get8BitCode() << 3));
        }
    }

    public static class Inc_RR
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_RR_INDEX);
        private Expression argument;

        public Inc_RR(Scope context, Expression arguments) {
            super(context);
            this.argument = arguments;
        }

        @Override
        public Expression getSize() {
            return this.indexifyDirect(this.argument.getRegister(), IntegerLiteral.ONE);
        }

        @Override
        public byte[] getBytes() {
            Register register = this.argument.getRegister();
            return this.indexifyDirect(register, (byte)(3 | register.get16BitCode() << 4));
        }
    }
}

