/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Add;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.expressions.Subtract;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.InstructionFactory;
import nl.grauw.glass.instructions.InstructionObject;

public class Djnz
extends InstructionFactory {
    @Override
    public InstructionObject createObject(Scope context, Expression arguments) {
        if (Djnz_N.ARGUMENTS.check(arguments)) {
            return new Djnz_N(context, arguments);
        }
        throw new ArgumentException();
    }

    public static class Djnz_N
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_N);
        private Expression argument;

        public Djnz_N(Scope context, Expression arguments) {
            super(context);
            this.argument = arguments;
        }

        @Override
        public Expression getSize() {
            return IntegerLiteral.TWO;
        }

        @Override
        public byte[] getBytes() {
            int offset = new Subtract(this.argument, new Add(this.context.getAddress(), this.getSize())).getInteger();
            if (offset < -128 || offset > 127) {
                throw new ArgumentException("Jump offset out of range: " + offset);
            }
            return new byte[]{16, (byte)offset};
        }
    }
}

