/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.BinaryOperator;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Type;

public class Divide
extends BinaryOperator {
    public Divide(Expression dividend, Expression divisor) {
        super(dividend, divisor);
    }

    @Override
    public Divide copy(Context context) {
        return new Divide(this.term1.copy(context), this.term2.copy(context));
    }

    public Expression getDividend() {
        return this.term1;
    }

    public Expression getDivisor() {
        return this.term2;
    }

    @Override
    public Expression get(Expression type) {
        if (type.is(Type.INTEGER)) {
            int divisor = this.term2.getInteger();
            if (divisor == 0) {
                throw new EvaluationException("Division by zero.");
            }
            return IntegerLiteral.of(this.term1.getInteger() / divisor);
        }
        return super.get(type);
    }

    @Override
    public String getLexeme() {
        return "/";
    }
}

