/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Type;

public class CharacterLiteral
extends Expression {
    private final char character;

    public CharacterLiteral(char character) {
        this.character = character;
    }

    @Override
    public CharacterLiteral copy(Context context) {
        return this;
    }

    public char getCharacter() {
        return this.character;
    }

    @Override
    public boolean is(Expression type) {
        return type.is(Type.INTEGER);
    }

    @Override
    public Expression get(Expression type) {
        if (type.is(Type.INTEGER)) {
            return IntegerLiteral.of(this.character);
        }
        return super.get(type);
    }

    public String toString() {
        String escaped = Character.toString(this.character);
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("'", "\\'");
        escaped = escaped.replace("\u0000", "\\0");
        escaped = escaped.replace("\u0007", "\\a");
        escaped = escaped.replace("\t", "\\t");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\u001b", "\\e");
        return "'" + escaped + "'";
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }
}

