/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.BinaryOperator;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Type;

public class Add
extends BinaryOperator {
    public Add(Expression augend, Expression addend) {
        super(augend, addend);
    }

    @Override
    public Add copy(Context context) {
        return new Add(this.term1.copy(context), this.term2.copy(context));
    }

    public Expression getAugend() {
        return this.term1;
    }

    public Expression getAddend() {
        return this.term2;
    }

    @Override
    public boolean is(Expression type) {
        if (type.is(Type.REGISTER)) {
            if (this.term1.is(Type.REGISTER)) {
                Register register = this.term1.getRegister();
                return register.isIndex() && register.isPair();
            }
            return false;
        }
        return super.is(type);
    }

    @Override
    public Expression get(Expression type) {
        Register register;
        if (type.is(Type.INTEGER)) {
            return IntegerLiteral.of(this.term1.getInteger() + this.term2.getInteger());
        }
        if (type.is(Type.REGISTER) && this.term1.is(Type.REGISTER) && (register = this.term1.getRegister()).isIndex() && register.isPair()) {
            return new Register(register, new Add(register.getIndexOffset(), this.term2));
        }
        return super.get(type);
    }

    @Override
    public String getLexeme() {
        return "+";
    }
}

