/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import nl.grauw.glass.Line;
import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;

public class Source {
    private final Scope scope;
    private List<Line> lines = new ArrayList<Line>();

    public Source(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public Line getLastLine() {
        return this.lines.size() > 0 ? this.lines.get(this.lines.size() - 1) : null;
    }

    public Source copy(Scope scope) {
        Source newSource = new Source(scope);
        for (Line line : this.lines) {
            newSource.addLine(line.copy(new Scope(scope)));
        }
        return newSource;
    }

    public void addLine(Line line) {
        this.lines.add(line);
    }

    public void addLines(List<Line> lines) {
        this.lines.addAll(lines);
    }

    public void assemble(OutputStream output) throws IOException {
        this.register();
        this.expand();
        this.resolve();
        byte[] objectCode = this.getBytes();
        output.write(objectCode, 0, objectCode.length);
    }

    public void register() {
        this.register(this.scope);
    }

    public void register(Scope scope) {
        for (Line line : this.lines) {
            line.register(scope);
        }
    }

    public void expand() {
        ArrayList<Line> newLines = new ArrayList<Line>();
        this.expand(newLines);
        this.lines = newLines;
    }

    public void expand(List<Line> newLines) {
        for (Line line : this.lines) {
            line.expand(newLines);
        }
    }

    public Expression resolve() {
        return this.resolve(IntegerLiteral.ZERO);
    }

    public Expression resolve(Expression address) {
        for (Line line : this.lines) {
            address = line.resolve(address);
        }
        return address;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (Line line : this.lines) {
            byte[] object = line.getBytes();
            bytes.write(object, 0, object.length);
        }
        return bytes.toByteArray();
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        for (Line line : this.lines) {
            string.append(line);
            string.append('\n');
        }
        return string.toString();
    }
}

