/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.PrintStream;
import nl.grauw.glass.Line;
import nl.grauw.glass.Source;
import nl.grauw.glass.SourceFile;
import nl.grauw.glass.instructions.Ds;
import nl.grauw.glass.instructions.Section;

public class ListingWriter {
    private final PrintStream output;
    private SourceFile sourceFile;

    public ListingWriter(PrintStream output) {
        this.output = output;
        this.sourceFile = null;
    }

    public void write(Source source) {
        for (Line line : source.getLines()) {
            this.write(line);
            if (!(line.getInstruction() instanceof Ds)) continue;
            for (Section section : ((Ds)line.getInstruction()).getSections()) {
                this.write(section.getSource());
            }
        }
    }

    public void write(Line line) {
        SourceFile.SourceFileSpan span = line.getSourceSpan();
        if (this.sourceFile != span.getSourceFile()) {
            this.sourceFile = span.getSourceFile();
            this.output.println("# source: " + this.sourceFile.getPath());
        }
        int lineEnd = span.lineEnd + (span.lineStart == span.lineEnd ? 1 : 0);
        for (int lineNumber = span.lineStart; lineNumber < lineEnd; ++lineNumber) {
            this.output.format("% 4d\t%04X\t", lineNumber + 1, line.getScope().getAddress().getInteger());
            if (lineNumber == lineEnd - 1) {
                byte[] bytes;
                for (byte b : bytes = line.getBytes()) {
                    this.output.format("%02X\t", b);
                }
                for (int i = bytes.length; i < 4; ++i) {
                    this.output.print("\t");
                }
            } else {
                this.output.print("\t\t\t\t");
            }
            if (lineNumber < span.lineEnd) {
                this.output.println(this.sourceFile.getLine(lineNumber));
                continue;
            }
            this.output.println();
        }
    }
}

