/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.grauw.glass.SourceFile;

public class AssemblyException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final List<SourceFile.SourceFileSpan> contexts = new ArrayList<SourceFile.SourceFileSpan>();

    public AssemblyException() {
        this((Throwable)null);
    }

    public AssemblyException(String message) {
        this(message, null);
    }

    public AssemblyException(Throwable cause) {
        this("Error during assembly.", null);
    }

    public AssemblyException(String message, Throwable cause) {
        super(message, cause);
    }

    public void addContext(SourceFile.SourceFileSpan sourceSpan) {
        this.contexts.add(sourceSpan);
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        for (SourceFile.SourceFileSpan context : this.contexts) {
            message = message + "\n" + context;
        }
        return message;
    }

    public String getPlainMessage() {
        return super.getMessage();
    }

    public List<SourceFile.SourceFileSpan> getContexts() {
        return Collections.unmodifiableList(this.contexts);
    }
}

