/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.BinaryOperator;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Type;

public class Subtract
extends BinaryOperator {
    public Subtract(Expression minuend, Expression subtrahend) {
        super(minuend, subtrahend);
    }

    @Override
    public Subtract copy(Context context) {
        return new Subtract(this.term1.copy(context), this.term2.copy(context));
    }

    public Expression getMinuend() {
        return this.term1;
    }

    public Expression getSubtrahend() {
        return this.term2;
    }

    @Override
    public boolean is(Expression type) {
        if (type.is(Type.REGISTER)) {
            if (this.term1.is(Type.REGISTER) && this.term2.is(Type.INTEGER)) {
                Register register = this.term1.getRegister();
                return register.isIndex() && register.isPair();
            }
            return false;
        }
        return super.is(type);
    }

    @Override
    public Expression get(Expression type) {
        Register register;
        if (type.is(Type.INTEGER)) {
            return IntegerLiteral.of(this.term1.getInteger() - this.term2.getInteger());
        }
        if (type.is(Type.REGISTER) && this.term1.is(Type.REGISTER) && this.term2.is(Type.INTEGER) && (register = this.term1.getRegister()).isIndex() && register.isPair()) {
            return new Register(register, new Subtract(register.getIndexOffset(), this.term2));
        }
        return super.get(type);
    }

    @Override
    public String getLexeme() {
        return "-";
    }
}

