/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import java.util.ArrayDeque;
import java.util.Deque;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.expressions.Add;
import nl.grauw.glass.expressions.And;
import nl.grauw.glass.expressions.Annotation;
import nl.grauw.glass.expressions.Complement;
import nl.grauw.glass.expressions.Divide;
import nl.grauw.glass.expressions.Equals;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.GreaterOrEquals;
import nl.grauw.glass.expressions.GreaterThan;
import nl.grauw.glass.expressions.Group;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.IfElse;
import nl.grauw.glass.expressions.Index;
import nl.grauw.glass.expressions.LessOrEquals;
import nl.grauw.glass.expressions.LessThan;
import nl.grauw.glass.expressions.LogicalAnd;
import nl.grauw.glass.expressions.LogicalOr;
import nl.grauw.glass.expressions.Member;
import nl.grauw.glass.expressions.Modulo;
import nl.grauw.glass.expressions.Multiply;
import nl.grauw.glass.expressions.Negative;
import nl.grauw.glass.expressions.Not;
import nl.grauw.glass.expressions.NotEquals;
import nl.grauw.glass.expressions.Or;
import nl.grauw.glass.expressions.Positive;
import nl.grauw.glass.expressions.Sequence;
import nl.grauw.glass.expressions.ShiftLeft;
import nl.grauw.glass.expressions.ShiftRight;
import nl.grauw.glass.expressions.ShiftRightUnsigned;
import nl.grauw.glass.expressions.Subtract;
import nl.grauw.glass.expressions.Xor;

public class ExpressionBuilder {
    private Deque<Expression> operands = new ArrayDeque<Expression>();
    private Deque<Operator> operators = new ArrayDeque<Operator>();
    private int groupCount = 0;
    public final Operator POSITIVE = new Operator(Precedence.UNARY, Associativity.RIGHT_TO_LEFT, "+"){

        @Override
        public void evaluate() {
            ExpressionBuilder.this.operands.push(new Positive((Expression)ExpressionBuilder.this.operands.pop()));
        }
    };
    public final Operator NEGATIVE = new Operator(Precedence.UNARY, Associativity.RIGHT_TO_LEFT, "-"){

        @Override
        public void evaluate() {
            ExpressionBuilder.this.operands.push(new Negative((Expression)ExpressionBuilder.this.operands.pop()));
        }
    };
    public final Operator COMPLEMENT = new Operator(Precedence.UNARY, Associativity.RIGHT_TO_LEFT, "~"){

        @Override
        public void evaluate() {
            ExpressionBuilder.this.operands.push(new Complement((Expression)ExpressionBuilder.this.operands.pop()));
        }
    };
    public final Operator NOT = new Operator(Precedence.UNARY, Associativity.RIGHT_TO_LEFT, "!"){

        @Override
        public void evaluate() {
            ExpressionBuilder.this.operands.push(new Not((Expression)ExpressionBuilder.this.operands.pop()));
        }
    };
    public final Operator MEMBER = new Operator(Precedence.MEMBER, Associativity.LEFT_TO_RIGHT, "."){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            if (!(operandRight instanceof Identifier)) {
                throw new ExpressionError("Member operator right hand side must be an identifier.");
            }
            ExpressionBuilder.this.operands.push(new Member((Expression)ExpressionBuilder.this.operands.pop(), (Identifier)operandRight));
        }
    };
    public final Operator MULTIPLY = new Operator(Precedence.MULTIPLICATION, Associativity.LEFT_TO_RIGHT, "*"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Multiply((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator DIVIDE = new Operator(Precedence.MULTIPLICATION, Associativity.LEFT_TO_RIGHT, "/"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Divide((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator MODULO = new Operator(Precedence.MULTIPLICATION, Associativity.LEFT_TO_RIGHT, "%"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Modulo((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator ADD = new Operator(Precedence.ADDITION, Associativity.LEFT_TO_RIGHT, "+"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Add((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator SUBTRACT = new Operator(Precedence.ADDITION, Associativity.LEFT_TO_RIGHT, "-"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Subtract((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator SHIFT_LEFT = new Operator(Precedence.SHIFT, Associativity.LEFT_TO_RIGHT, "<<"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new ShiftLeft((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator SHIFT_RIGHT = new Operator(Precedence.SHIFT, Associativity.LEFT_TO_RIGHT, ">>"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new ShiftRight((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator SHIFT_RIGHT_UNSIGNED = new Operator(Precedence.SHIFT, Associativity.LEFT_TO_RIGHT, ">>>"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new ShiftRightUnsigned((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator LESS_THAN = new Operator(Precedence.COMPARISON, Associativity.LEFT_TO_RIGHT, "<"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new LessThan((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator LESS_OR_EQUALS = new Operator(Precedence.COMPARISON, Associativity.LEFT_TO_RIGHT, "<="){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new LessOrEquals((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator GREATER_THAN = new Operator(Precedence.COMPARISON, Associativity.LEFT_TO_RIGHT, ">"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new GreaterThan((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator GREATER_OR_EQUALS = new Operator(Precedence.COMPARISON, Associativity.LEFT_TO_RIGHT, ">="){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new GreaterOrEquals((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator EQUALS = new Operator(Precedence.EQUALITY, Associativity.LEFT_TO_RIGHT, "="){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Equals((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator NOT_EQUALS = new Operator(Precedence.EQUALITY, Associativity.LEFT_TO_RIGHT, "!="){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new NotEquals((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator AND = new Operator(Precedence.AND, Associativity.LEFT_TO_RIGHT, "&"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new And((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator XOR = new Operator(Precedence.XOR, Associativity.LEFT_TO_RIGHT, "^"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Xor((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator OR = new Operator(Precedence.OR, Associativity.LEFT_TO_RIGHT, "|"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Or((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator LOGICAL_AND = new Operator(Precedence.LOGICAL_AND, Associativity.LEFT_TO_RIGHT, "&&"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new LogicalAnd((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator LOGICAL_OR = new Operator(Precedence.LOGICAL_OR, Associativity.LEFT_TO_RIGHT, "||"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new LogicalOr((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator ANNOTATION = new Operator(Precedence.ANNOTATION, Associativity.RIGHT_TO_LEFT, " "){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            Expression operandLeft = (Expression)ExpressionBuilder.this.operands.pop();
            if (!(operandLeft instanceof Identifier)) {
                throw new ExpressionError("Annotation left hand side must be an identifier.");
            }
            ExpressionBuilder.this.operands.push(new Annotation((Identifier)operandLeft, operandRight));
        }
    };
    public final Operator SEQUENCE = new Operator(Precedence.SEQUENCE, Associativity.RIGHT_TO_LEFT, ","){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Sequence((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }
    };
    public final Operator TERNARYIF = new Operator(Precedence.TERNARYIFELSE, Associativity.RIGHT_TO_LEFT, "?"){

        @Override
        public void evaluate() {
            throw new ExpressionError("Ternary if (?) without else (:).");
        }
    };
    public final Operator TERNARYELSE = new Operator(Precedence.TERNARYIFELSE, Associativity.RIGHT_TO_LEFT, ":"){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            while (ExpressionBuilder.this.operators.peek() == ExpressionBuilder.this.TERNARYELSE) {
                ((Operator)ExpressionBuilder.this.operators.pop()).evaluate();
            }
            if (ExpressionBuilder.this.operators.peek() != ExpressionBuilder.this.TERNARYIF) {
                throw new ExpressionError("Ternary else (:) without if (?).");
            }
            ExpressionBuilder.this.operators.pop();
            Expression operandMiddle = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new IfElse((Expression)ExpressionBuilder.this.operands.pop(), operandMiddle, operandRight));
        }
    };
    public final Operator GROUP_OPEN = new Operator(Precedence.GROUPING, Associativity.RIGHT_TO_LEFT, "("){

        @Override
        public void evaluate() {
            ExpressionBuilder.this.operands.push(new Group((Expression)ExpressionBuilder.this.operands.pop()));
        }

        @Override
        public void tryEvaluate() {
            super.tryEvaluate();
            ExpressionBuilder.this.operators.push(ExpressionBuilder.this.SENTINEL);
            ExpressionBuilder.this.groupCount++;
        }
    };
    public final Operator GROUP_CLOSE = new Operator(Precedence.NONE, Associativity.LEFT_TO_RIGHT, ")"){

        @Override
        public void evaluate() {
            throw new AssemblyException("Can not evaluate group close.");
        }

        @Override
        public void tryEvaluate() {
            super.tryEvaluate();
            if (ExpressionBuilder.this.operators.pop() != ExpressionBuilder.this.GROUP_CLOSE) {
                throw new AssemblyException("Group close expected.");
            }
            if (ExpressionBuilder.this.operators.pop() != ExpressionBuilder.this.SENTINEL) {
                throw new AssemblyException("Sentinel expected.");
            }
            if (ExpressionBuilder.this.operators.peek() != ExpressionBuilder.this.GROUP_OPEN) {
                throw new ExpressionError("Group open expected.");
            }
            ExpressionBuilder.this.groupCount--;
        }
    };
    public final Operator INDEX_OPEN = new Operator(Precedence.MEMBER, Associativity.LEFT_TO_RIGHT, "["){

        @Override
        public void evaluate() {
            Expression operandRight = (Expression)ExpressionBuilder.this.operands.pop();
            ExpressionBuilder.this.operands.push(new Index((Expression)ExpressionBuilder.this.operands.pop(), operandRight));
        }

        @Override
        public void tryEvaluate() {
            super.tryEvaluate();
            ExpressionBuilder.this.operators.push(ExpressionBuilder.this.SENTINEL);
            ExpressionBuilder.this.groupCount++;
        }
    };
    public final Operator INDEX_CLOSE = new Operator(Precedence.NONE, Associativity.LEFT_TO_RIGHT, "]"){

        @Override
        public void evaluate() {
            throw new AssemblyException("Can not evaluate index close.");
        }

        @Override
        public void tryEvaluate() {
            super.tryEvaluate();
            if (ExpressionBuilder.this.operators.pop() != ExpressionBuilder.this.INDEX_CLOSE) {
                throw new AssemblyException("Index close expected.");
            }
            if (ExpressionBuilder.this.operators.pop() != ExpressionBuilder.this.SENTINEL) {
                throw new AssemblyException("Sentinel expected.");
            }
            if (ExpressionBuilder.this.operators.peek() != ExpressionBuilder.this.INDEX_OPEN) {
                throw new ExpressionError("Index open expected.");
            }
            ExpressionBuilder.this.groupCount--;
        }
    };
    public final Operator SENTINEL = new Operator(Precedence.NONE, Associativity.RIGHT_TO_LEFT, "#"){

        @Override
        public void evaluate() {
            throw new AssemblyException("Can not evaluate sentinel.");
        }
    };

    public ExpressionBuilder() {
        this.operators.push(this.SENTINEL);
    }

    public void addValueToken(Expression value) {
        this.operands.push(value);
    }

    public void addOperatorToken(Operator operator) {
        operator.tryEvaluate();
    }

    public Expression getExpression() {
        if (this.operands.isEmpty() || this.operators.isEmpty()) {
            throw new AssemblyException("Operands / operators is empty: " + this);
        }
        this.SENTINEL.tryEvaluate();
        if (this.operators.pop() != this.SENTINEL) {
            throw new AssemblyException("Sentinel expected.");
        }
        if (this.operators.size() > 1 && this.operators.peek() == this.SENTINEL) {
            throw new ExpressionError("Group close expected.");
        }
        if (this.operands.size() > 1 || this.operators.size() != 1) {
            throw new AssemblyException("Not all operands / operators were processed: " + this);
        }
        return this.operands.pop();
    }

    public boolean hasOpenGroup() {
        return this.groupCount > 0;
    }

    public String toString() {
        return "" + this.operands + " / " + this.operators;
    }

    private static enum Precedence {
        GROUPING,
        MEMBER,
        UNARY,
        MULTIPLICATION,
        ADDITION,
        SHIFT,
        COMPARISON,
        EQUALITY,
        AND,
        XOR,
        OR,
        LOGICAL_AND,
        LOGICAL_OR,
        TERNARYIFELSE,
        ANNOTATION,
        SEQUENCE,
        NONE;

    }

    private static enum Associativity {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }

    private abstract class Operator {
        private Precedence precedence;
        private Associativity associativity;
        private String token;

        private Operator(Precedence precedence, Associativity associativity, String token) {
            this.precedence = precedence;
            this.associativity = associativity;
            this.token = token;
        }

        public void tryEvaluate() {
            while (!((Operator)ExpressionBuilder.this.operators.peek()).yieldsTo(this)) {
                ((Operator)ExpressionBuilder.this.operators.pop()).evaluate();
            }
            ExpressionBuilder.this.operators.push(this);
        }

        public boolean yieldsTo(Operator other) {
            if (this.associativity == Associativity.LEFT_TO_RIGHT) {
                return this.precedence.ordinal() > other.precedence.ordinal();
            }
            return this.precedence.ordinal() >= other.precedence.ordinal();
        }

        public abstract void evaluate();

        public String toString() {
            return this.token;
        }
    }

    public static class ExpressionError
    extends AssemblyException {
        private static final long serialVersionUID = 1L;

        public ExpressionError(String message) {
            super("Expression error: " + message);
        }
    }
}

