/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.GlobalScope;
import nl.grauw.glass.Line;
import nl.grauw.glass.Parser;
import nl.grauw.glass.Scope;
import nl.grauw.glass.Source;
import nl.grauw.glass.SourceFile;
import nl.grauw.glass.directives.Directive;
import nl.grauw.glass.directives.Ds;
import nl.grauw.glass.directives.Equ;
import nl.grauw.glass.directives.If;
import nl.grauw.glass.directives.Incbin;
import nl.grauw.glass.directives.Include;
import nl.grauw.glass.directives.Instruction;
import nl.grauw.glass.directives.Irp;
import nl.grauw.glass.directives.Macro;
import nl.grauw.glass.directives.Proc;
import nl.grauw.glass.directives.Rept;
import nl.grauw.glass.directives.Section;
import nl.grauw.glass.directives.Terminator;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Sequence;
import nl.grauw.glass.expressions.Type;

public class SourceBuilder {
    private static final List<String> END_TERMINATORS = Arrays.asList("end", "END");
    private static final List<String> ENDM_TERMINATORS = Arrays.asList("endm", "ENDM");
    private static final List<String> ENDP_TERMINATORS = Arrays.asList("endp", "ENDP");
    private static final List<String> ENDS_TERMINATORS = Arrays.asList("ends", "ENDS");
    private static final List<String> ELSE_TERMINATORS = Arrays.asList("else", "ELSE", "endif", "ENDIF");
    private static final List<String> ENDIF_TERMINATORS = Arrays.asList("endif", "ENDIF");
    private final Source source;
    private final List<String> terminators;
    private final List<Path> includePaths;
    private static final List<SourceFile> sourceFiles = new ArrayList<SourceFile>();

    public SourceBuilder(List<Path> includePaths) {
        this(new Scope(new GlobalScope()), includePaths);
    }

    private SourceBuilder(Scope scope, List<Path> includePaths) {
        this(scope, END_TERMINATORS, includePaths);
    }

    private SourceBuilder(Scope scope, List<String> terminators, List<Path> includePaths) {
        this.source = new Source(scope);
        this.terminators = terminators;
        this.includePaths = includePaths;
    }

    public boolean hasLoadedSourceFile(Path path) {
        try {
            for (SourceFile sourceFile : sourceFiles) {
                if (!Files.isSameFile(path, sourceFile.getPath())) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private List<Path> getIncludePaths(SourceFile sourceFile) {
        ArrayList<Path> basePaths = new ArrayList<Path>();
        Path path = sourceFile.getPath();
        if (path != null) {
            basePaths.add(path.resolveSibling(path.getFileSystem().getPath("", new String[0])));
        }
        basePaths.addAll(this.includePaths);
        return basePaths;
    }

    private Source parseInclude(Expression sourcePath, SourceFile baseSourceFile, boolean once) {
        for (Path includePath : this.getIncludePaths(baseSourceFile)) {
            Path fullPath = includePath.resolve(sourcePath.getString());
            if (!Files.exists(fullPath, new LinkOption[0])) continue;
            if (once && this.hasLoadedSourceFile(fullPath)) {
                return null;
            }
            return this.parse(fullPath);
        }
        throw new AssemblyException("Include file not found: " + sourcePath.getString());
    }

    public Source parse(Path sourcePath) {
        SourceFile sourceFile = new SourceFile(sourcePath);
        sourceFiles.add(sourceFile);
        return this.parse(sourceFile);
    }

    public Source parse(SourceFile sourceFile) {
        return this.parse(new Parser(sourceFile));
    }

    /*
     * Exception decompiling
     */
    public Source parse(Parser parser) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Directive getDirective(Line line, Parser parser) {
        switch (line.getMnemonic()) {
            case "equ": 
            case "EQU": {
                return new Equ();
            }
            case "include": 
            case "INCLUDE": {
                return this.getIncludeDirective(line, parser.getSourceFile());
            }
            case "incbin": 
            case "INCBIN": {
                return new Incbin(this.getIncludePaths(parser.getSourceFile()));
            }
            case "macro": 
            case "MACRO": {
                return new Macro(this.parseBlock(line.getScope(), ENDM_TERMINATORS, parser));
            }
            case "rept": 
            case "REPT": {
                return new Rept(this.parseBlock(line.getScope(), ENDM_TERMINATORS, parser));
            }
            case "irp": 
            case "IRP": {
                return new Irp(this.parseBlock(line.getScope(), ENDM_TERMINATORS, parser));
            }
            case "proc": 
            case "PROC": {
                return new Proc(this.parseBlock(line.getScope(), ENDP_TERMINATORS, parser));
            }
            case "if": 
            case "IF": {
                Source thenBlock = this.parseBlock(new Scope(line.getScope()), ELSE_TERMINATORS, parser);
                Source elseBlock = !ENDIF_TERMINATORS.contains(thenBlock.getLastLine().getMnemonic()) ? this.parseBlock(new Scope(line.getScope()), ENDIF_TERMINATORS, parser) : new Source(new Scope(line.getScope()));
                return new If(thenBlock, elseBlock);
            }
            case "section": 
            case "SECTION": {
                return new Section(this.parseBlock(this.source.getScope(), ENDS_TERMINATORS, parser));
            }
            case "ds": 
            case "DS": {
                return new Ds();
            }
            case "end": 
            case "END": 
            case "endm": 
            case "ENDM": 
            case "endp": 
            case "ENDP": 
            case "ends": 
            case "ENDS": 
            case "else": 
            case "ELSE": 
            case "endif": 
            case "ENDIF": {
                if (!this.terminators.contains(line.getMnemonic())) {
                    if (line.getMnemonic() == "end" || line.getMnemonic() == "END") {
                        throw new AssemblyException("Unexpected end of file. Expecting: " + this.terminators.toString());
                    }
                    throw new AssemblyException("Unexpected " + line.getMnemonic() + ".");
                }
                return new Terminator();
            }
        }
        return new Instruction();
    }

    private Directive getIncludeDirective(Line line, SourceFile sourceFile) {
        String annotation;
        boolean once = false;
        Expression argument = line.getArguments();
        if (argument.is(Type.ANNOTATION) && ("once".equals(annotation = argument.getAnnotation().getName()) || "ONCE".equals(annotation))) {
            argument = argument.getAnnotee();
            once = true;
        }
        if (line.getArguments() instanceof Sequence) {
            throw new AssemblyException("Include only accepts 1 argument.");
        }
        if (!argument.is(Type.STRING)) {
            throw new AssemblyException("A string literal is expected.");
        }
        SourceBuilder sourceBuilder = new SourceBuilder(this.source.getScope(), this.includePaths);
        sourceBuilder.parseInclude(argument, sourceFile, once);
        return new Include(sourceBuilder.source);
    }

    private Source parseBlock(Scope scope, List<String> terminators, Parser parser) {
        return new SourceBuilder(scope, terminators, this.includePaths).parse(parser);
    }
}

