/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.util.ArrayList;
import java.util.Collections;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Line;
import nl.grauw.glass.Scope;
import nl.grauw.glass.SourceFile;
import nl.grauw.glass.expressions.Expression;

public class LineBuilder {
    private ArrayList<String> labels;
    private String mnemonic;
    private Expression arguments;
    private String comment;

    public void setLabel(String label) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        this.labels.add(label);
    }

    public void setMnemonic(String mnemonic) {
        if (this.mnemonic != null) {
            throw new AssemblyException("Mnemonic already set.");
        }
        this.mnemonic = mnemonic;
    }

    public void setArguments(Expression arguments) {
        if (this.mnemonic == null) {
            throw new AssemblyException("Mnemonic not set.");
        }
        if (this.arguments != null) {
            throw new AssemblyException("Arguments already set.");
        }
        this.arguments = arguments;
    }

    public void setComment(String comment) {
        this.comment = this.comment == null ? comment : this.comment + "\n" + comment;
    }

    public boolean isEmpty() {
        return this.mnemonic == null;
    }

    public Line getLine(Scope scope, SourceFile.SourceFileSpan sourceSpan) {
        Line line = new Line(scope, this.labels == null ? Collections.emptyList() : this.labels, this.mnemonic, this.arguments, this.comment, sourceSpan);
        this.labels = null;
        this.mnemonic = null;
        this.arguments = null;
        this.comment = null;
        return line;
    }
}

