/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.util.List;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.Scope;
import nl.grauw.glass.SourceFile;
import nl.grauw.glass.directives.Directive;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.instructions.Empty;
import nl.grauw.glass.instructions.InstructionFactory;
import nl.grauw.glass.instructions.InstructionObject;

public class Line {
    private final Scope scope;
    private final List<String> labels;
    private final String mnemonic;
    private final Expression arguments;
    private final String comment;
    private final SourceFile.SourceFileSpan sourceSpan;
    private InstructionFactory instruction;
    private InstructionObject instructionObject;
    private Directive directive;

    public Line(Scope scope, List<String> labels, String mnemonic, Expression arguments, String comment, SourceFile.SourceFileSpan sourceSpan) {
        if (mnemonic == null) {
            throw new AssemblyException("Missing mnemonic.");
        }
        this.scope = scope;
        this.labels = labels;
        this.mnemonic = mnemonic;
        this.arguments = arguments;
        this.comment = comment;
        this.sourceSpan = sourceSpan;
    }

    public Line copy(Scope scope) {
        Line newLine = new Line(scope, this.labels, this.mnemonic, this.arguments != null ? this.arguments.copy(scope) : null, this.comment, this.sourceSpan);
        newLine.setDirective(this.directive.copy(scope));
        return newLine;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getComment() {
        return this.comment;
    }

    public SourceFile.SourceFileSpan getSourceSpan() {
        return this.sourceSpan;
    }

    public void setDirective(Directive directive) {
        this.directive = directive;
    }

    public void setInstruction(InstructionFactory instruction) {
        this.instruction = instruction;
    }

    public InstructionFactory getInstruction() {
        if (this.instruction == null) {
            this.instruction = this.mnemonic != null ? this.scope.getSymbol(this.mnemonic).getInstruction() : Empty.INSTANCE;
        }
        return this.instruction;
    }

    public void register(Scope sourceScope) {
        try {
            this.directive.register(sourceScope, this);
        }
        catch (AssemblyException e) {
            e.addContext(this.sourceSpan);
            throw e;
        }
    }

    public void expand(List<Line> lines) {
        try {
            this.getInstruction().expand(this, lines);
        }
        catch (AssemblyException e) {
            e.addContext(this.sourceSpan);
            throw e;
        }
    }

    public Expression resolve(Expression address) {
        try {
            this.instructionObject = this.getInstruction().createObject(this.scope, this.arguments);
            return this.instructionObject.resolve(address);
        }
        catch (AssemblyException e) {
            e.addContext(this.sourceSpan);
            throw e;
        }
    }

    public Expression getSize() {
        try {
            return this.instructionObject.getSize();
        }
        catch (AssemblyException e) {
            e.addContext(this.sourceSpan);
            throw e;
        }
    }

    public byte[] getBytes() {
        try {
            return this.instructionObject.getBytes();
        }
        catch (AssemblyException e) {
            e.addContext(this.sourceSpan);
            throw e;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String label : this.labels) {
            builder.append(label).append(":\n");
        }
        if (this.mnemonic != null) {
            builder.append("\t").append(this.mnemonic);
            if (this.arguments != null) {
                builder.append(" ").append(this.arguments);
            }
        }
        if (this.comment != null) {
            if (this.mnemonic != null) {
                builder.append(" ");
            }
            builder.append(";").append(this.comment);
        }
        return builder.toString();
    }
}

