;  if(a>b)
;  {
;    if(c>a)
;      // order = CAB
;    else if(c>b)
;      // order = ACB
;    else
;      // order = ABC
;  }
;  else // b>=a
;  {
;    if(a>c)
;      // order = BAC
;    else if(c>b)
;      // order = CBA
;    else // b>=c && c>=a
;      // order = BCA
;  }

  cp b
  jr c,l1
  ; a>=b
  cp c
  jr nc,l4
  ; c>a && a>=b
  ; order = CAB
  jp scan_order_CAB
l4:
  ; a>=c
  ld a,b
  cp c
  jr nc,l5
  ; a>=c && c>b
  ; order = ACB
  jp scan_order_ACB
l5:
  ; a>=b && b>=c
  ; order = ABC
  jp scan_order_ABC
l1:
  ; b>a
  cp c
  jr c,l2
  ; b>a && a>=c
  ; order = BAC
  jp scan_order_BAC
l2:
  ; c>a
  ld a,c
  cp b
  jr c,l3
  ; c>=b && b>a
  ; order = CBA
  jp scan_order_CBA
l3:
  ; b>c && c>a
  ; order = BCA
  jp scan_order_BCA


scan_order_CAB: ; C>=A>=B
  REPT 2
    rrc a
    rrc b
    rrc c
  ENDM
  ; 76543210
  ; SSGCCCCC    G = Guard bit
scan_order_CAB.loopB:
  dec b     ;  5C
  bit 5,b   ; 10C
  jr z,scan_order_CAB.loopB_out ; 13C
  ld (hl),0 ; 11C
  inc hl    ;  7C
  jr scan_order_CAB.loopB       ; 13C
scan_order_CAB.loopB_out:

  ; B can now be re-purposed.
  push af

  ld a,b
  ld b,a
  REPT 2
    rlca
  ENDM
  and 3
  ld (hl),b
  inc hl
  ld b,4

  pop af
scan_order_CAB.loopA:
  dec a
  bit 5,a
  jr z,scan_order_CAB.loopA_out
  ld (hl),b
  inc hl
  jr scan_order_CAB.loopA
scan_order_CAB.loopA_out:

  ; A and B can now be re-purposed.
  REPT 2
    rlca
  ENDM
  and 3
  or %00000100 ; Column index
  ld b,a
  ld c,0
  ld hl,char_table
  add hl,bc
  ld a,(hl)

  ld (hl),a
  inc hl
  ld b,xx

scan_order_CAB.loopC:
  dec c
  bit 5,c
  jr z,scan_order_CAB.loopC_out
  ld (hl),b
  inc hl
  jr scan_order_CAB.loopC
scan_order_CAB.loopC_out:

  ; A, B, and C can now be re-purposed.
  ld a,c
  REPT 2
    rlca
  ENDM
  and 3
  or b
  ld (hl),a
  inc hl
  ld b,xx

