
V9990_WAIT_FOR_COMMAND_READY: MACRO
      in a,(V9P_STATUS)
      rra
      jr c,$-3
      ENDM

V9990_SET_BORDER_COLOUR: MACRO ?c
      push af
      ld a,V9R_BDRPCOL
      out (V9P_REGSLCT),a
      ld a,?c
      out (V9P_REGDATA),a
      pop af
      ENDM

; BIOS ROM
CGTABL: equ #0004

; BIOS Routines
RSLREG: equ #0138
WSLREG: equ #013B
ENASLT: equ #0024

; System Variables
FORCLR: equ #F3E9
BAKCLR: equ #F3EA
BDRCLR: equ #F3EB
TXTNAM: equ #F3B3
TXTCGP: equ #F3B7
HKEY:   equ #FD9A
CLIKSW: equ #F3DB
T32NAM: equ #F3BD
T32COL: equ #F3BF
T32CGP: equ #F3C1
T32ATR: equ #F3C3
T32PAT: equ #F3C5
GRPNAM: equ #F3C7
GRPCOL: equ #F3C9
GRPCGP: equ #F3CB
GRPATR: equ #F3CD
GRPPAT: equ #F3CF

; VRAM
PATTBL: equ #0000
NAMTBL: equ #0800
SATRBL: equ #1400
COLTBL: equ #1480
SPATBL: equ #1800

; Ports
VDPDAT: equ #98 ; Port #0
VDPCTL: equ #99 ; Port #1
VDPPAL: equ #9A ; Port #2
VDPREG: equ #9B ; Port #3
SLOTSL: equ #A8
KEYROW: equ #A9
KEYSEL: equ #AA
PSGREG: equ #A0
PSGWRI: equ #A1
PSGREA: equ #A2
OPLLRG: equ #7C
OPLLDT: equ #7D

; PSG Registers
PSG_REG_TONE_0: equ 0
PSG_REG_TONE_1: equ 1
PSG_REG_TONE_2: equ 2
PSG_REG_TONE_3: equ 3
PSG_REG_TONE_4: equ 4
PSG_REG_TONE_5: equ 5
PSG_REG_NOISE:  equ 6
PSG_REG_MIXER:  equ 7 ; Important note: bit 6 must be 0, and bit 7 must be 1.
PSG_REG_AMP_0:  equ 8
PSG_REG_AMP_1:  equ 9
PSG_REG_AMP_2:  equ 10
PSG_REG_ENV_0:  equ 11
PSG_REG_ENV_1:  equ 12
PSG_REG_ENV_2:  equ 13

; V9990 Ports
V9P_VRAMDAT: equ #60 ; VRAM Data
V9P_PALDATA: equ #61 ; Palette Data
V9P_COMDATA: equ #62 ; Command Data
V9P_REGDATA: equ #63 ; Register Data
V9P_REGSLCT: equ #64 ; Register Select
V9P_STATUS:  equ #65 ; Status
V9P_IFLAGS:  equ #66 ; Interrupt Flags
V9P_SYSCTRL: equ #67 ; System Control

; V9990 Registers
V9R_VRAMWR0: equ  0  ; VRAM Write Address
V9R_VRAMWR1: equ  1
V9R_VRAMWR2: equ  2
V9R_VRAMRD0: equ  3  ; VRAM Read Address
V9R_VRAMRD1: equ  4
V9R_VRAMRD2: equ  5
V9R_SCNMOD0: equ  6  ; Screen Mode
V9R_SCNMOD1: equ  7
V9R_CONTROL: equ  8  ; Control
V9R_INTRPT0: equ  9  ; Interrupt
V9R_INTRPT1: equ 10
V9R_INTRPT2: equ 11
V9R_INTRPT3: equ 12
V9R_PALCTRL: equ 13  ; Palette Control
V9R_PALPNTR: equ 14  ; Palette Pointer
V9R_BDRPCOL: equ 15  ; Backdrop Colour
V9R_DISPADJ: equ 16  ; Display Adjust
V9R_SCROLL0: equ 17  ; Scroll Control
V9R_SCROLL1: equ 18
V9R_SCROLL2: equ 19
V9R_SCROLL3: equ 10
V9R_SCROLL4: equ 21
V9R_SCROLL5: equ 22
V9R_SCROLL6: equ 23
V9R_SCROLL7: equ 24
V9R_SPRBASE: equ 25  ; Sprite Generator Base Address
V9R_LCDCTRL: equ 26  ; LCD Control
V9R_PRICTRL: equ 27  ; Priority Control
V9R_CURPOFS: equ 28  ; Cursor Sprite Palette Offset
V9R_CMNDWR0: equ 32  ; Command (Write)
V9R_CMDLOGT: equ 45  ; Logic + TP
V9R_FONTCOL: equ 48  ; Font Colour
V9R_CMNDOPC: equ 52  ; Command Operation Code
V9R_CMNDRD0: equ 53  ; Command (Read)

; V9990 Opcodes
V9O_STOP:     equ  0
V9O_LMMC:     equ  1
V9O_LMMV:     equ  2
V9O_LMCM:     equ  3
V9O_LMMM:     equ  4
V9O_CMMC:     equ  5
V9O_CMMM:     equ  7
V9O_BMXL:     equ  8
V9O_BMLX:     equ  9
V9O_BMLL:     equ 10
V9O_LINE:     equ 11
V9O_SEARCH:   equ 12
V9O_POINT:    equ 13
V9O_PSET:     equ 14
V9O_ADVANCE:  equ 15

; Constants
FRAME_WIDTH:          equ 256 ; B1 mode
FRAME_HEIGHT:         equ 212
FRAME_BPP:            equ 2
IMAGE_SPACE_W:        equ 512
IMAGE_SPACE_H:        equ 4096

  ; ROM
  org #0000

  ; Interrupt Service Routine
  ds #0038 - $
  push af
  ; Set the border colour
  ld a,(scanline_counter)
  out (V9P_REGDATA),a
  inc a
  ld (scanline_counter),a
  ; Acknowledge the raised interrupt(s)
  ;in a,(V9P_IFLAGS)
  ld a,2
  out (V9P_IFLAGS),a
  pop af
  ei
  ret

top:
  ; Initialise RAM
  ld hl,RAM_START
  ld (hl),0
  ld de,RAM_START+1
  ld bc,RAM_END-RAM_START-1
  ldir

  ; Set up the V9990
  call v9990_reset
  call v9990_setmode_B1_BP2_512x4096
  call v9990_set_512k

  ld a,V9R_CONTROL
  out (V9P_REGSLCT),a
  ld a,%01000010
  out (V9P_REGDATA),a

  ; Set some common parameters

  ; Set DIY+DIX
  ld a,44
  out (V9P_REGSLCT),a
  ld a,%00000000
  out (V9P_REGDATA),a ; R#44

  ; Set Write Mask
  ld a,46
  out (V9P_REGSLCT),a
  ld a,%11111111
  out (V9P_REGDATA),a ; R#46
  out (V9P_REGDATA),a ; R#47

  ; Set FC - this value will stay constant throughout.
  ld a,V9R_FONTCOL
  out (V9P_REGSLCT),a
  ld a,%00000000
  out (V9P_REGDATA),a ; R#48
  out (V9P_REGDATA),a ; R#49

  ; Clear all of VRAM
  V9990_WAIT_FOR_COMMAND_READY
  ld a,V9R_CMNDWR0+4
  out (V9P_REGSLCT),a
  ; Set DX
  xor a
  out (V9P_REGDATA),a ; R#36
  out (V9P_REGDATA),a ; R#37
  ; Set DY
  out (V9P_REGDATA),a ; R#38
  out (V9P_REGDATA),a ; R#39
  ; Set NX
  out (V9P_REGDATA),a ; R#40
  ld a,IMAGE_SPACE_W>>8 ; 512
  out (V9P_REGDATA),a ; R#41
  ; Set NY
  xor a
  out (V9P_REGDATA),a ; R#42
  ld a,IMAGE_SPACE_H>>8 ; 4096
  out (V9P_REGDATA),a ; R#43

  ; Set Logical Operation, for clearing to zero.
  ld a,V9R_CMDLOGT
  out (V9P_REGSLCT),a
  ld a,%00001100
  out (V9P_REGDATA),a ; R#45

  ; Set OP
  ld a,V9R_CMNDOPC
  out (V9P_REGSLCT),a
  ld a,V9O_LMMV<<4
  out (V9P_REGDATA),a

  V9990_WAIT_FOR_COMMAND_READY

  ; Reset Scroll Registers
  ld a,V9R_SCROLL0
  out (V9P_REGSLCT),a
  ld a,#00
  out (V9P_REGDATA),a ; R#17
  ld a,#00
  out (V9P_REGDATA),a ; R#18
  ld a,#00
  out (V9P_REGDATA),a ; R#19
  ld a,#00
  out (V9P_REGDATA),a ; R#20
  ld a,#00
  out (V9P_REGDATA),a ; R#21
  ld a,#00
  out (V9P_REGDATA),a ; R#22
  ld a,#00
  out (V9P_REGDATA),a ; R#23
  ld a,#00
  out (V9P_REGDATA),a ; R#24

  ; Fill the (64-entry) palette
  ld a,V9R_PALPNTR
  out (V9P_REGSLCT),a
  xor a
  out (V9P_REGDATA),a
  ld c,V9P_PALDATA
  ld b,64*3
  ld hl,palette_rgb
  otir

  V9990_SET_BORDER_COLOUR 0

  IF 1
  ; Set interrupt enables
  ld a,V9R_INTRPT0
  out (V9P_REGSLCT),a
  ld a,%00000010 ; IECE, IEH, IEV
  out (V9P_REGDATA),a

  ld a,V9R_INTRPT1
  out (V9P_REGSLCT),a
  ld a,%00000000 ; Interrupt Line (bit 7-0)
  out (V9P_REGDATA),a

  ld a,V9R_INTRPT2
  out (V9P_REGSLCT),a
  ld a,%10000000 ; Interrupt Line (bit 9-8) and IEHM
  out (V9P_REGDATA),a

  ld a,V9R_INTRPT3
  out (V9P_REGSLCT),a
  ld a,0 ; Interrupt Horizontal Position
  out (V9P_REGDATA),a

  ld a,V9R_BDRPCOL | %11000000 ; WII | RII
  out (V9P_REGSLCT),a
  ENDIF

  ; Enable the display
  call v9990_enable_display

  ld a,V9R_BDRPCOL | %11000000 ; WII | RII
  out (V9P_REGSLCT),a

  ei

mainloop:

  ; Check for end of V9990 vertical non-display period.
  in a,(V9P_STATUS)
  and %01000000
  jr nz,$-2-2

  ; Check for start of V9990 vertical non-display period.
  in a,(V9P_STATUS)
  and %01000000
  jr z,$-2-2

  ld a,0
  ld (scanline_counter),a

  jp mainloop

; ---------------------- V9990 common ----------------------

v9990_setmode_B1_BP2_512x4096:
  ;     |    Register #6    |       Register #7       |
  ; MCS DSPM DCKM XIMM CLRM C25M SM1 SM PAL EO IL HSCN
  ;   0   10   00   01   00    0   0  0   0  0  0    0
  ld a,#00 ; MCS = 0
  out (V9P_SYSCTRL),a
  ld a,V9R_SCNMOD0
  out (V9P_REGSLCT),a
  ld a,%10000100
  out (V9P_REGDATA),a
  ld a,%00000000
  out (V9P_REGDATA),a
  ; Palette Control
  ld a,V9R_PALCTRL
  out (V9P_REGSLCT),a
  ld a,%00000000
  out (V9P_REGDATA),a
  ret

v9990_enable_display:
  ld a,V9R_CONTROL
  out (V9P_REGSLCT),a
  ld a,%11000010
  out (V9P_REGDATA),a
  ret

v9990_set_512k:
  ld a,V9R_CONTROL | %11000000
  out (V9P_REGSLCT),a
  in a,(V9P_REGDATA)
  and %11111000
  or  %00000010
  out (V9P_REGDATA),a
  ret

v9990_reset:
  ld a,#02
  out (V9P_SYSCTRL),a
  xor a
  out (V9P_SYSCTRL),a
  ld a,V9R_SCNMOD0
  out (V9P_REGSLCT),a
  ld a,%11000000 ; Stand-by mode
  out (V9P_REGDATA),a
  ret

v9990_set_border_colour:
  push af
  ld b,a
  ld a,V9R_BDRPCOL
  out (V9P_REGSLCT),a
  ld a,b
  out (V9P_REGDATA),a
  pop af
  ret


  ds #4000 - $

; ---------------------- MSX ROM header for BIOS ----------------------

  org #4000

  db "AB"
  dw INIT
  db 0,0,0,0,0,0,0,0,0,0,0,0

INIT:
  di
  im 1 ; Interrupt mode 1 - RST #38
  ld sp,#F000

  ; Turn off the TMS9918 / V9938 so that we don't get useless interrupts from it.
  ld a,%00000000
  out (VDPCTL),a
  ld a,#81
  out (VDPCTL),a

  ; Switch pages 0 and 2 to the (primary) slot in which this
  ; cartridge is inserted. It is assumed that page 1 is already mapped.
  call RSLREG
  ld b,a
  ;    33221100
  and %00001100
  ld c,a
  REPT 4
    rlca
  ENDM
  or c
  REPT 2
    rrca
  ENDM
  ld c,a
  ld a,b
  ;    33221100
  and %11001100
  or c
  ; Now, since WSLREG is mapped into page 0 currently it can't be called.
  ; So the slot select register port is used directly instead.
  out (SLOTSL),a

  ; Page 3 is kept as RAM, making 16Kbyte of total RAM available.
  ; WARNING: After this point, the BIOS is not available at all.
  jp top

; ---------------------- Tables ----------------------

palette_rgb:
  REPT 64/4
    db (31*0)/3, (31*0)/3, (31*0)/3
    db (31*1)/3, (31*1)/3, (31*1)/3
    db (31*2)/3, (31*2)/3, (31*2)/3
    db (31*3)/3, (31*3)/3, (31*3)/3
  ENDM

  ds #C000 - $

; ---------------------- Variables ----------------------

; 16Kbyte RAM
  org #C000
RAM_START:
scanline_counter:
  ds virtual 4
RAM_END:
  ds virtual #E000 - $

