; BOING BALL

ALIGN: MACRO ?boundary
      ds ?boundary - 1 - ($ + ?boundary - 1) % ?boundary
      ENDM

ALIGN_VIRTUAL: MACRO ?boundary
      ds virtual (?boundary - 1 - ($ + ?boundary - 1) % ?boundary)
      ENDM

MAKE_SPRITE: MACRO ?x, ?y, ?p
      db ?y, ?x, ?p, #00
      ENDM

MAKE_HMMV: MACRO ?dx, ?dy, ?nx, ?ny, ?cr
      db #00,#00                ; R#32, R#33
      db #00,#00                ; R#34, R#35
      db ?dx&#FF,(?dx>>8)&1     ; R#36, R#37
      db ?dy&#FF,(?dy>>8)&3     ; R#38, R#39
      db ?nx&#FF,(?nx>>8)&1     ; R#40, R#41
      db ?ny&#FF,(?ny>>8)&3     ; R#42, R#43
      db ?cr                    ; R#44
      db %00000000              ; R#45
      db %11000000              ; R#46
      ENDM

MAKE_HMMC: MACRO ?dx, ?dy, ?nx, ?ny
      db #00,#00                ; R#32, R#33
      db #00,#00                ; R#34, R#35
      db ?dx&#FF,(?dx>>8)&1     ; R#36, R#37
      db ?dy&#FF,(?dy>>8)&3     ; R#38, R#39
      db ?nx&#FF,(?nx>>8)&1     ; R#40, R#41
      db ?ny&#FF,(?ny>>8)&3     ; R#42, R#43
      db %00000000              ; R#44 (placeholder)
      db %00000000              ; R#45
      db %11110000              ; R#46
      ENDM

MAKE_LMMC: MACRO ?dx, ?dy, ?nx, ?ny, ?op
      db #00,#00                ; R#32, R#33
      db #00,#00                ; R#34, R#35
      db ?dx&#FF,(?dx>>8)&1     ; R#36, R#37
      db ?dy&#FF,(?dy>>8)&3     ; R#38, R#39
      db ?nx&#FF,(?nx>>8)&1     ; R#40, R#41
      db ?ny&#FF,(?ny>>8)&3     ; R#42, R#43
      db %00000000              ; R#44 (placeholder)
      db %00000000              ; R#45
      db %10110000|?op          ; R#46
      ENDM

MAKE_HMMM: MACRO ?sx, ?sy, ?dx, ?dy, ?nx, ?ny
      db ?sx&#FF,(?sx>>8)&1     ; R#32, R#33
      db ?sy&#FF,(?sy>>8)&3     ; R#34, R#35
      db ?dx&#FF,(?dx>>8)&1     ; R#36, R#37
      db ?dy&#FF,(?dy>>8)&3     ; R#38, R#39
      db ?nx&#FF,(?nx>>8)&1     ; R#40, R#41
      db ?ny&#FF,(?ny>>8)&3     ; R#42, R#43
      db #00                    ; R#44
      db %00000000              ; R#45
      db %11010000              ; R#46
      ENDM

MAKE_LMMM: MACRO ?sx, ?sy, ?dx, ?dy, ?nx, ?ny, ?op
      db ?sx&#FF,(?sx>>8)&1     ; R#32, R#33
      db ?sy&#FF,(?sy>>8)&3     ; R#34, R#35
      db ?dx&#FF,(?dx>>8)&1     ; R#36, R#37
      db ?dy&#FF,(?dy>>8)&3     ; R#38, R#39
      db ?nx&#FF,(?nx>>8)&1     ; R#40, R#41
      db ?ny&#FF,(?ny>>8)&3     ; R#42, R#43
      db #00                    ; R#44
      db %00000000              ; R#45
      db %10010000|?op          ; R#46
      ENDM

MAKE_LMMV: MACRO ?dx, ?dy, ?nx, ?ny, ?cr, ?op
      db #00,#00                ; R#32, R#33
      db #00,#00                ; R#34, R#35
      db ?dx&#FF,(?dx>>8)&1     ; R#36, R#37
      db ?dy&#FF,(?dy>>8)&3     ; R#38, R#39
      db ?nx&#FF,(?nx>>8)&1     ; R#40, R#41
      db ?ny&#FF,(?ny>>8)&3     ; R#42, R#43
      db ?cr                    ; R#44
      db %00000000              ; R#45
      db %10000000|?op          ; R#46
      ENDM

MAKE_YMMM: MACRO ?sy, ?dx, ?dy, ?ny, ?dix
      db #00,#00                ; R#32, R#33
      db ?sy&#FF,(?sy>>8)&3     ; R#34, R#35
      db ?dx&#FF,(?dx>>8)&1     ; R#36, R#37
      db ?dy&#FF,(?dy>>8)&3     ; R#38, R#39
      db #00,#00                ; R#40, R#41
      db ?ny&#FF,(?ny>>8)&3     ; R#42, R#43
      db #00                    ; R#44
      db (?dix&1)<<2            ; R#45
      db %11100000              ; R#46
      ENDM

MAKE_LINE: MACRO ?x, ?y, ?long, ?short, ?cr, ?diy, ?dix, ?maj, ?op
      db #00,#00                  ; R#32, R#33
      db #00,#00                  ; R#34, R#35
      db ?x&#FF,(?x>>8)&1         ; R#36, R#37
      db ?y&#FF,(?y>>8)&3         ; R#38, R#39
      db ?long&#FF,(?long>>8)&1   ; R#40, R#41
      db ?short&#FF,(?short>>8)&3 ; R#42, R#43
      db ?cr                      ; R#44
      db ?maj|(?dix<<2)|(?diy<<3) ; R#45
      db %01110000|?op            ; R#46
      ENDM

COMMAND_SX:   equ 0
COMMAND_SY:   equ 2
COMMAND_DX:   equ 4
COMMAND_DY:   equ 6
COMMAND_SIZE: equ 15

MAKE_PALETTE_ENTRY: MACRO ?r, ?g, ?b
      dw ?b|(?r<<4)|(?g<<8)
      ENDM

PREPARE_LDIRVM_FIXED: MACRO ?destination
      ; Set address counter A16 to A14
      ld a,(?destination>>14)&#FF
      out (VDPCTL),a
      ld a,128+14 ; R#14
      out (VDPCTL),a
      ; Set the address counter A7 to A0
      ld a,?destination&#FF
      out (VDPCTL),a
      ; Set the address counter A13 to A8 and operation mode
      ld a,((?destination>>8)&#3F)|64
      out (VDPCTL),a
      ENDM

LDIRVM_FIXED: MACRO ?source, ?destination, ?length
      PREPARE_LDIRVM_FIXED ?destination
      ld c,VDPDAT
      ld hl,?source
      ld b,?length&#FF
      ld d,(?length>>8)&#FF
      inc d
    ldirvm_fixed_loop:
      otir
      dec d
      jr nz,ldirvm_fixed_loop
      ENDM

WAIT_FOR_VBLANK: MACRO
      ; Poll the HR bit in S#2 to wait for VBLANK
      in a,(VDPCTL)
      and 1<<6
      jr z,$-2-2
      ENDM

WAIT_FOR_NOT_VBLANK: MACRO
      ; Poll the HR bit in S#2 to wait for scan outside of VBLANK
      in a,(VDPCTL)
      and 1<<6
      jr nz,$-2-2
      ENDM

; BIOS ROM
CGTABL: equ #0004

; BIOS Routines
RSLREG: equ #0138
WSLREG: equ #013B
ENASLT: equ #0024

; System Variables
FORCLR: equ #F3E9
BAKCLR: equ #F3EA
BDRCLR: equ #F3EB
TXTNAM: equ #F3B3
TXTCGP: equ #F3B7
HKEY:   equ #FD9A
CLIKSW: equ #F3DB
T32NAM: equ #F3BD
T32COL: equ #F3BF
T32CGP: equ #F3C1
T32ATR: equ #F3C3
T32PAT: equ #F3C5
GRPNAM: equ #F3C7
GRPCOL: equ #F3C9
GRPCGP: equ #F3CB
GRPATR: equ #F3CD
GRPPAT: equ #F3CF

; VRAM
PATTBL: equ #0000
NAMTBL: equ #0800
SATRBL: equ #1400
COLTBL: equ #1480
SPATBL: equ #1800

; Ports
VDPDAT: equ #98 ; Port #0
VDPCTL: equ #99 ; Port #1
VDPPAL: equ #9A ; Port #2
VDPREG: equ #9B ; Port #3
SLOTSL: equ #A8
KEYROW: equ #A9
KEYSEL: equ #AA
PSGREG: equ #A0
PSGWRI: equ #A1
PSGREA: equ #A2
OPLLRG: equ #7C
OPLLDT: equ #7D

; PSG Registers
PSG_REG_TONE_0: equ 0
PSG_REG_TONE_1: equ 1
PSG_REG_TONE_2: equ 2
PSG_REG_TONE_3: equ 3
PSG_REG_TONE_4: equ 4
PSG_REG_TONE_5: equ 5
PSG_REG_NOISE:  equ 6
PSG_REG_MIXER:  equ 7 ; Important note: bit 6 must be 0, and bit 7 must be 1.
PSG_REG_AMP_0:  equ 8
PSG_REG_AMP_1:  equ 9
PSG_REG_AMP_2:  equ 10
PSG_REG_ENV_0:  equ 11
PSG_REG_ENV_1:  equ 12
PSG_REG_ENV_2:  equ 13

; Constants
DEBUG_ENABLED:       equ 0
COLOUR_BLACK         equ 1
COLOUR_MEDIUM_GREEN  equ 2
COLOUR_LIGHT_GREEN   equ 3
COLOUR_DARK_BLUE     equ 4
COLOUR_LIGHT_BLUE    equ 5
COLOUR_DARK_RED      equ 6
COLOUR_CYAN          equ 7
COLOUR_MEDIUM_RED    equ 8
COLOUR_LIGHT_RED     equ 9
COLOUR_DARK_YELLOW   equ 10
COLOUR_LIGHT_YELLOW  equ 11
COLOUR_DARK_GREEN    equ 12
COLOUR_MAGENTA       equ 13
COLOUR_GREY          equ 14
COLOUR_WHITE         equ 15

BIT_BACKGROUND_OR_WIRE equ 1<<0
BIT_BALL_SHADOW        equ 1<<1
BIT_BALL_MASK          equ 1<<2
BIT_BALL_COLOUR        equ 1<<3

UNUSED_BIT_COMBINATION_1 equ BIT_BALL_COLOUR
UNUSED_BIT_COMBINATION_2 equ BIT_BALL_COLOUR|BIT_BACKGROUND_OR_WIRE
UNUSED_BIT_COMBINATION_3 equ BIT_BALL_COLOUR|BIT_BALL_SHADOW

ARC_FRAMES             equ  20
ARC_TOP                equ  15
ARC_HEIGHT             equ 95

NUM_BACKDROP_LINES     equ (backdrop_lines_end-backdrop_lines)/COMMAND_SIZE

BALL_SIZE              equ 54
LEFT_EDGE              equ 128-BALL_SIZE*2
RIGHT_EDGE             equ 128+BALL_SIZE*2-BALL_SIZE


; VRAM Layout
BASE_PATTERN_LAYOUT:            equ #0000
BASE_PATTERN_LAYOUT_PAGE_1_G4:  equ #8000
BASE_SPRITE_PATTERNS:           equ #7000+#8000
BASE_SPRITE_COLOURS:            equ #7800+#8000
BASE_SPRITE_ATTRIBUTES:         equ #7A00+#8000

; V9938 Logic Op Codes
LOGIC_OP_IMP:  equ %0000
LOGIC_OP_AND:  equ %0001
LOGIC_OP_OR:   equ %0010
LOGIC_OP_XOR:  equ %0011
LOGIC_OP_NOT:  equ %0100
LOGIC_OP_TIMP: equ %1000
LOGIC_OP_TAND: equ %1001
LOGIC_OP_TOR:  equ %1010
LOGIC_OP_TXOR: equ %1011
LOGIC_OP_TNOT: equ %1100

; VDP Mode Register Flags
; R#0
VDP_DG:   equ (1 << 6)
VDP_IE2:  equ (1 << 5)
VDP_IE1:  equ (1 << 4)
VDP_M5:   equ (1 << 3)
VDP_M4:   equ (1 << 2)
VDP_M3:   equ (1 << 1)
; R#1
VDP_BL:   equ (1 << 6)
VDP_IE0:  equ (1 << 5)
VDP_M1:   equ (1 << 4)
VDP_M2:   equ (1 << 3)
VDP_SI:   equ (1 << 1)
VDP_MAG:  equ (1 << 0)
; R#8
VDP_MS:   equ (1 << 7)
VDP_LP:   equ (1 << 6)
VDP_TP:   equ (1 << 5)
VDP_CB:   equ (1 << 4)
VDP_VR:   equ (1 << 3)
VDP_SPD:  equ (1 << 1)
VDP_BW:   equ (1 << 0)
; R#9
VDP_LN:   equ (1 << 7)
VDP_S1:   equ (1 << 5)
VDP_S0:   equ (1 << 4)
VDP_IL:   equ (1 << 3)
VDP_E0:   equ (1 << 2)
VDP_NT:   equ (1 << 1)
VDP_DC:   equ (1 << 0)

; 32Kbyte ROM, where the main game code is
  org #4000

  db "AB"
  dw INIT
  db 0,0,0,0,0,0,0,0,0,0,0,0

INIT:
  di
  ld sp,#F000

  ; Switch page 2 to the (primary) slot in which this
  ; cartridge is inserted. It is assumed that page 1 is already mapped.
  call RSLREG
  ld b,a
  ;    33221100
  and %00001100
  ld c,a
  REPT 2
    rlca
  ENDM
  or c
  ld c,a
  ld a,b
  ;    33221100
  and %11000011
  or c
  call WSLREG

  ; Page 3 is kept as RAM, making 16Kbyte of total RAM available.
  ; The BIOS is kept around, in page 0.

  di

  ; Initialise RAM
  ld hl,RAM_START
  ld (hl),0
  ld de,RAM_START+1
  ld bc,RAM_END-RAM_START-1
  ldir

  ; Set GRAPHIC4 mode and enable display
  ; M5 M4 M3 M2 M1
  ;  0  1  1  0  0
  ld a,VDP_SI|VDP_BL
  out (VDPCTL),a
  ld a,#81
  out (VDPCTL),a
  ld a,VDP_M3|VDP_M4
  out (VDPCTL),a
  ld a,#80
  out (VDPCTL),a
  ld a,VDP_SPD|VDP_VR|VDP_TP
  out (VDPCTL),a
  ld a,#88
  out (VDPCTL),a
  ld a,0
  out (VDPCTL),a
  ld a,#89
  out (VDPCTL),a

  ld a,%00000000
  out (VDPCTL),a
  ld a,128+45
  out (VDPCTL),a

  ; Set the border colour
  ld a,UNUSED_BIT_COMBINATION_1
  out (VDPCTL),a
  ld a,#87
  out (VDPCTL),a

  ; Pattern layout
  ld a,(BASE_PATTERN_LAYOUT>>10)|%00011111
  out (VDPCTL),a
  ld a,#82
  out (VDPCTL),a
  ; Sprite attributes
  ld a,((BASE_SPRITE_ATTRIBUTES>>7)&#FF)|7
  out (VDPCTL),a
  ld a,#85
  out (VDPCTL),a
  ld a,BASE_SPRITE_ATTRIBUTES>>15
  out (VDPCTL),a
  ld a,#8B
  out (VDPCTL),a
  ; Sprite patterns
  ld a,BASE_SPRITE_PATTERNS>>11
  out (VDPCTL),a
  ld a,#86
  out (VDPCTL),a

  ; Clear the framebuffer
  call wait_for_vdp_ready
  ld a,32
  out (VDPCTL),a
  ld a,#91
  out (VDPCTL),a
  ld hl,hmmv_clear_vram
  ld c,VDPREG
  ld b,COMMAND_SIZE
  otir
  call wait_for_vdp_ready

  ; Upload the ball frames
  ld hl,hmmc_ball_frames
  ld de,ball_frames
  ld b,(64*64/2*8)/64
  call execute_hmmc_x64

  ; Draw the backdrop lines
  ld b,NUM_BACKDROP_LINES
  ld hl,backdrop_lines
backdrop_lines_loop:
  push bc
  call wait_for_vdp_ready
  ld a,32
  out (VDPCTL),a
  ld a,#91
  out (VDPCTL),a
  ld c,VDPREG
  ld b,COMMAND_SIZE
  otir
  pop bc
  djnz backdrop_lines_loop

  ld a,LEFT_EDGE
  ld (ball_x_pos),a

  ; The loop
frameloop:

  call wait_for_vdp_ready

  WAIT_FOR_NOT_VBLANK

  WAIT_FOR_VBLANK

  ; Set palette
  ld a,#00
  out (VDPCTL),a
  ld a,#90
  out (VDPCTL),a
  ld hl,palette_0
  ld a,(ball_frame_counter)
  dec a
  and 8
  jr z,$+2+3
  ld hl,palette_1
  ld c,VDPPAL
  ld b,32
  otir

  ; Set the page for double-buffering
  ; Pattern layout
  ld a,(BASE_PATTERN_LAYOUT>>10)|%00011111
  ld hl,page_flip
  bit 0,(hl)
  jr nz,$+2+2
  ld a,(BASE_PATTERN_LAYOUT_PAGE_1_G4>>10)|%00011111
  out (VDPCTL),a
  ld a,#82
  out (VDPCTL),a

  ; Clear the bits at the previous boing ball position
  ; Copy the command
  ld hl,lmmv_clear_ball_bits
  ld de,command_ram
  ld bc,COMMAND_SIZE
  ldir
  ; Set the X position
  ld a,(ball_x_pos_prev_prev)
  ld (ix+COMMAND_DX+0),a
  ; Set the page to draw to
  ld ix,command_ram
  ld a,(page_flip)
  ld (ix+COMMAND_DY+1),a
  ; Set the Y position
  ld a,(arc_frame_prev_prev)
  ld l,a
  ld h,0
  ld bc,arc_table
  add hl,bc
  ld a,(hl)
  ld (ix+COMMAND_DY+0),a
  ; Execute the command
  ld a,32
  out (VDPCTL),a
  ld a,#91
  out (VDPCTL),a
  ld hl,command_ram
  ld c,VDPREG
  ld b,COMMAND_SIZE
  otir

  ; Draw the boing ball
  ; Copy the command
  ld a,(ball_frame_counter)
  and 7
  ld l,a
  ld h,0
  add hl,hl
  ld bc,lmmm_ball_frame_addr_table
  add hl,bc
  ld a,(hl)
  inc hl
  ld h,(hl)
  ld l,a
  ld de,command_ram
  ld bc,COMMAND_SIZE
  ldir
  ; Set the X position
  ld a,(ball_x_pos)
  ld (ix+COMMAND_DX+0),a
  ; Set the page to draw to
  ld ix,command_ram
  ld a,(page_flip)
  ld (ix+COMMAND_DY+1),a
  ; Set the Y position
  ld a,(arc_frame)
  ld l,a
  ld h,0
  ld bc,arc_table
  add hl,bc
  ld a,(hl)
  ld (ix+COMMAND_DY+0),a
  call wait_for_vdp_ready
  ; Execute the command
  ld a,32
  out (VDPCTL),a
  ld a,#91
  out (VDPCTL),a
  ld hl,command_ram
  ld c,VDPREG
  ld b,COMMAND_SIZE
  otir

  ; Do frame logic
  ld a,(ball_x_pos_prev)
  ld (ball_x_pos_prev_prev),a
  ld a,(ball_x_pos)
  ld (ball_x_pos_prev),a

  ld a,(ball_x_pingpong)
  and 1
  call z,inc_ball_x_pos
  call nz,dec_ball_x_pos

  ld a,(arc_frame_prev)
  ld (arc_frame_prev_prev),a
  ld a,(arc_frame)
  ld (arc_frame_prev),a

  ld a,(arc_pingpong)
  and 1
  call z,inc_arc_frame
  call nz,dec_arc_frame

  ld hl,ball_frame_counter
  inc (hl)

  ld hl,page_flip
  ld a,(hl)
  xor 1
  ld (hl),a

  jp frameloop

inc_arc_frame:
  push af
  ld hl,arc_frame
  ld a,(hl)
  inc (hl)
  cp ARC_FRAMES-2
  jr nz,$+2+2+3
  ld a,1
  ld (arc_pingpong),a
  pop af
  ret

dec_arc_frame:
  push af
  ld hl,arc_frame
  ld a,(hl)
  dec (hl)
  jr nz,$+2+2+3
  ld a,0
  ld (arc_pingpong),a
  pop af
  ret

inc_ball_x_pos:
  push af
  ld hl,ball_x_pos
  ld a,(hl)
  inc (hl)
  cp RIGHT_EDGE-1
  jr nz,$+2+2+3
  ld a,1
  ld (ball_x_pingpong),a
  pop af
  ret

dec_ball_x_pos:
  push af
  ld hl,ball_x_pos
  ld a,(hl)
  dec (hl)
  cp LEFT_EDGE+1
  jr nz,$+2+2+3
  ld a,0
  ld (ball_x_pingpong),a
  pop af
  ret

wait_for_vdp_ready:
  ld a,#02
  out (VDPCTL),a
  ld a,#8F
  out (VDPCTL),a
  in a,(VDPCTL)
  rra
  jr c,wait_for_vdp_ready
  ret

wait_for_vdp_transfer_ready:
  ld a,#02
  out (VDPCTL),a
  ld a,#8F
  out (VDPCTL),a
  in a,(VDPCTL)
  rla
  jr nc,$-1-2
  ret

; HL = Command address
; DE = Data address
;  B = Data Length / 64
execute_hmmc_x64:
  push bc
  call wait_for_vdp_ready
  ld a,32
  out (VDPCTL),a
  ld a,#91
  out (VDPCTL),a
  ld c,VDPREG
  REPT 12
    outi
  ENDM
  ; First byte of graphic must be loaded already before execution.
  ex de,hl
  outi
  ex de,hl
  inc hl
  outi
  outi
  ld c,#AC
  REPT 63
    call wait_for_vdp_transfer_ready
    ld a,(de)
    inc de
    out (VDPCTL),a
    ld a,c
    out (VDPCTL),a
  ENDM
  pop bc
  dec b
  ret z
  ld c,#AC
execute_hmmc_x64_tr_loop:
  REPT 64
    call wait_for_vdp_transfer_ready
    ld a,(de)
    inc de
    out (VDPCTL),a
    ld a,c
    out (VDPCTL),a
  ENDM
  dec b
  jp nz,execute_hmmc_x64_tr_loop
  ret

palette_0:
  incbin "palette_0.bin"
palette_1:
  incbin "palette_1.bin"
ball_frames:
  incbin "ball_frames_atlas.bin"

hmmv_clear_vram:
  MAKE_HMMV 0, 0, 256, 256*4, #00

hmmc_ball_frames:
  MAKE_HMMC 0, 256*2, 64*4, 64*2

lmmm_ball_frames:
  REPT 8,?I
    MAKE_LMMM (?I&3)*64, (?I/4)*64+256*2, 0, 128, 64, 64, LOGIC_OP_TOR
  ENDM
lmmm_ball_frame_addr_table:
  REPT 8,?I
    dw lmmm_ball_frames+?I*COMMAND_SIZE
  ENDM

lmmv_clear_ball_bits:
  MAKE_LMMV 0, 128, 64, 64, BIT_BACKGROUND_OR_WIRE | (BIT_BACKGROUND_OR_WIRE << 4), LOGIC_OP_AND

arc_table:
  REPT ARC_FRAMES,?I
    db ARC_TOP+(ARC_HEIGHT*?I*?I)/((ARC_FRAMES-1)*(ARC_FRAMES-1))
  ENDM

backdrop_lines:
  incbin "backdrop_lines_commands.bin"
backdrop_lines_end:

  db "(c) Edd Biddulph 2025"

  ds #C000 - $

; 16Kbyte RAM
  org #C000
RAM_START:
  ds virtual 16
ball_frame_counter:
  ds virtual 1
page_flip:
  ds virtual 1
command_ram:
  ds virtual 16
arc_frame:
  ds virtual 1
arc_frame_prev:
  ds virtual 1
arc_frame_prev_prev:
  ds virtual 1
arc_pingpong:
  ds virtual 1
ball_x_pos:
  ds virtual 1
ball_x_pos_prev:
  ds virtual 1
ball_x_pos_prev_prev:
  ds virtual 1
ball_x_pingpong:
  ds virtual 1
RAM_END:
