  ; acme.exe --cpu 6502 -o titlescreen.bin
  * = $B700

  JOYPAD1 = $4016
  JOYPAD2 = $4017

  TEMP = $FD ; 2B

  ; ROM
  INFO_NAMETABLE        = $8000
  INFO_NAMETABLE2       = $E800
  INFO_SPRITES          = $8400
  LOGO_SCROLL_IRQ       = $A700

  ; FamiTone2
  FamiToneInit          = $E000
  FamiToneSfxInit       = $E3DE
  FamiToneUpdate        = $E124
  FamiToneMusicPlay     = $E093
  FamiToneMusicStop     = $E0B7
  FamiToneMusicPause    = $E100
  FamiToneSfxPlay       = $E418
  FamiToneSamplePlay    = $E195

  ;RAM
  SPRITES_STAGING       = $0200
  FRAME_COUNT           = $0550
  BUTTONS               = $0551 ; A, B, Select, Start, Up, Down, Left, Right
  MENU_POSITION         = $0552
  SCROLL_POSITION       = $0553
  PREV_BUTTONS          = $055F

  ; Non-zeropage persistent variables
  INTERMISSION_MODE     = $05F0
  LEVEL_INDEX           = $05F1
  BONUSBALLS            = $05F2
  PERFECT_COUNT         = $05F3

  NMI_COUNTER           = $05FF

  ; -------------- Title screen --------------

titlescreen

  ; MMC3: Set mirroring to horizontal
  lda #$01
  sta $A000

  sei ; Disable interrupts

  ; Clear PPUADDR latch by reading PPUSTATUS
  bit $2002

  lda #$00
  sta $2001 ; Disable rendering

  ; Wait for vertical blank.
;- bit $2002
;  bpl -

  ; MMC: Set CHR banks
  lda #$00
  sta $8000 ; Select R0
  lda #12
  sta $8001 ; Set CHR bank 0 at $0000-$07FF
  lda #$01
  sta $8000 ; Select R1
  lda #14
  sta $8001 ; Set CHR bank 1 at $0800-$0FFF

  lda #$02
  sta $8000 ; Select R2
  lda #12
  sta $8001 ; Set CHR bank 16 at $1000-$13FF
  lda #$03
  sta $8000 ; Select R3
  lda #13
  sta $8001 ; Set CHR bank 17 at $1400-$17FF
  lda #$04
  sta $8000 ; Select R4
  lda #14
  sta $8001 ; Set CHR bank 14 at $1800-$1BFF
  lda #$05
  sta $8000 ; Select R5
  lda #15
  sta $8001 ; Set CHR bank 15 at $1C00-$1FFF

  ; Clear nametable 0
  lda #$20
  sta $2006
  lda #$00
  sta $2006
  lda #$4F
  ldx #$00
  ldy #3
- sta $2007
  inx
  bne -
  dey
  bne -
  ldx #$C0
- sta $2007
  dex
  bne -

  ; Clear attribute table 0
  ldx #64
  lda #$FF
- sta $2007
  dex
  bne -

  ; Clear nametable 2
  lda #$28
  sta $2006
  lda #$00
  sta $2006
  lda #$4F
  ldx #$00
  ldy #3
- sta $2007
  inx
  bne -
  dey
  bne -
  ldx #$C0
- sta $2007
  dex
  bne -

  ; Clear attribute table 1
  ldx #64
  lda #$FF
- sta $2007
  dex
  bne -

  ; Draw static text
  lda #$28
  sta $2006
  lda #$E5
  sta $2006
  ldx #(string_1_end-string_1_begin)
  ldy #(string_1_begin-STRINGS)
  jsr make_string_nametable

  lda #$28
  sta $2006
  lda #$0C
  sta $2006
  lda #$7F ; Arrow
  sta $2007
  lda #$50
  sta $2007
  ldx #(string_2_end-string_2_begin)
  ldy #(string_2_begin-STRINGS)
  jsr make_string_nametable

  lda #$28
  sta $2006
  lda #$2E
  sta $2006
  ldx #(string_3_end-string_3_begin)
  ldy #(string_3_begin-STRINGS)
  jsr make_string_nametable


  ; Create scaled logo nametable rows in PPU RAM
  ; for CYBER
  ldx #$80
  lda #$08
--
  ldy #$20
  sty $2006
  sta $2006
  ldy #$10
- stx $2007
  inx
  dey
  bne -
  clc
  adc #$20
  bcc --

  ; Create scaled logo nametable rows in PPU RAM
  ; for COASTER
  ldx #$80
  lda #$08
--
  ldy #$21
  sty $2006
  sta $2006
  ldy #$10
- stx $2007
  inx
  dey
  bne -
  clc
  adc #$20
  bcc --

  ; Create scaled logo nametable rows in PPU RAM
  ; for Blank 1
  ldx #$80
  lda #$08
--
  ldy #$22
  sty $2006
  sta $2006
  ldy #$4F
  stx $2007
  inx
!for i, 0, 13 {
  sty $2007
  inx
}
  stx $2007
  inx
  clc
  adc #$20
  bcc --

  ; Create scaled logo nametable rows in PPU RAM
  ; for Blank 2
  ldx #$80
  lda #$08
--
  ldy #$2A
  sty $2006
  sta $2006
  ldy #$4F
  stx $2007
  inx
!for i, 0, 13 {
  sty $2007
  inx
}
  stx $2007
  inx
  clc
  adc #$20
  bcc --

  ; Palette 0: Unused
  ; Palette 1: Inner parts of logo for CYBER, and sides
  ; Palette 2: Inner parts of logo for COASTER
  ; Palette 3: Outside of logo

  ; -----------------------------------------------------------------

  ; Set scaled logo attributes for CYBER
  lda #$23
  sta $2006
  lda #$C2
  sta $2006
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007

  lda #$23
  sta $2006
  lda #$CA
  sta $2006
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007

  ; Set scaled logo attributes for COASTER
  lda #$23
  sta $2006
  lda #$D2
  sta $2006
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%10101010
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%10101010
  sta $2007
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%10101010
  sta $2007

  lda #$23
  sta $2006
  lda #$DA
  sta $2006
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%10101010
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%10101010
  sta $2007
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%10101010
  sta $2007

  ; Set scaled logo attributes for Blank 1
  lda #$23
  sta $2006
  lda #$E2
  sta $2006
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007

  lda #$23
  sta $2006
  lda #$EA
  sta $2006
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%01010101
  sta $2007

  ; Set scaled logo attributes for Blank 2
  lda #$2B
  sta $2006
  lda #$E2
  sta $2006
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%00000000
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%00000000
  sta $2007
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%00000000
  sta $2007

  lda #$2B
  sta $2006
  lda #$EA
  sta $2006
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%00000000
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%00000000
  sta $2007
  sta $2007
  ;     BBBBTTTT
  ;     RRLLRRLL
  lda #%00000000
  sta $2007

  ; BG and sprites must use different pattern tables.
  ;     VPHBSINN
  ldx #%10010000 ; This way around makes the IRQ fire at the start of a scanline instead
                 ; of in the middle of H-blank.
  stx $2000 ; PPUCTRL

  ; Show nothing for one frame.
  ldx #%00000000
  stx $2001 ; PPUMASK

  ; Clear the zeropage
  ldx #$00
  txa
- sta $00,x
  inx
  bne -

  ; Copy titlescreen IRQ routine from ROM to RAM
  ldx #(irq2_end-irq2-1)
- lda irq2,x
  sta $0500,x
  dex
  bpl -

  ; Clear the ingame variables
  ldx #$30
- dex
  sta $0550,x
  bne -

  ; Clear the persistent variables since the game will start afresh
  lda #$00
  sta INTERMISSION_MODE
  sta LEVEL_INDEX
  sta BONUSBALLS
  sta PERFECT_COUNT

  ; Clear the sprites staging area
  ldx #$00
  txa
- sta SPRITES_STAGING,x
  inx
  bne -

  ; Set up "hider" sprites for the logo
  ldx #$00
- lda hiders,x
  sta SPRITES_STAGING,x
  inx
  cpx #(8*4)
  bne -

  ldx #2
  jsr init_music

  jsr read_joypad
  lda BUTTONS
  sta PREV_BUTTONS

  lda #0
  sta MENU_POSITION

  ; -----------------------------------------------------------------

  ; Wait for NMI
  lda NMI_COUNTER
- cmp NMI_COUNTER
  beq -

  ; Set the BG palette
  lda #$3F
  sta $2006
  lda #$00
  sta $2006
  ldx #$00
- lda #$00
  sta $2007
  inx
  cpx #$10
  bne -

  ; Set the sprites palette
  lda #$3F
  sta $2006
  lda #$10
  sta $2006
  lda #$20 ; Aliased to $3F00
  sta $2007
  lda #$1D
  sta $2007
  lda #$1D
  sta $2007
  lda #$1D
  sta $2007

  ; Workaround for potential palette corruption bug
  lda #$3F
  sta $2006
  lda #$00
  sta $2006
  sta $2006
  sta $2006

  ; Reset PPUSCROLL
  bit $2002
  lda #$00
  sta $2005 ; X scroll
  lda #$C0
  sta $2005 ; Y scroll

titlescreen_loop


  ; The IRQ sequence is done, so all register can be freely used again.

  ; Update the music after the IRQ sequence is done.
  jsr update_music

  ; Prepare the IRQ sequence

  lda FRAME_COUNT
  ror
  ror
  ror
  and #%11000000
  sta $40
  lda FRAME_COUNT
  lsr
  lsr
  and #%00000111
  clc
  adc #(LOGO_SCROLL_IRQ>>8)
  sta $41

  ldy #$3F
  lda FRAME_COUNT
  and #$20
  asl
  sta TEMP+0
  asl
  asl
  sta TEMP+1

- lda ($40),y
  sta $00,y
  dey
  ; Make a special case for blank lines
  lda ($40),y
  eor TEMP+0
  and #$40
  lsr
  lsr
  lsr
  tax
  stx $7E,y
  lda ($40),y
  cmp #255
  bne ++
  ; Shortcut for empty (not "blank") lines
  lda #192
  sta $00,y
  ldx #$00
  stx $01,y
  stx $80,y
  dey
  bpl -
++
  cmp #192
  bcc +
  and #(255-64)
+
  sta $00,y
  lda ($40),y
  bmi +
  ldx #$00
  stx $80,y
  eor TEMP+0
  sta $00,y
+ dey
  bpl -

  ; Don't alternate the area above the logo
  iny
  lda ($40),y
  sta $00,y
  iny
  lda ($40),y
  sta $00,y

  ; Show menu items below the logo
  lda #192
  sta $3C
  lda #0
  sta $3D
  lda #$00
  sta $80+$3C

  ; Wait for NMI
  lda NMI_COUNTER
- cmp NMI_COUNTER
  beq -

  ; ----------------------------------------------------------
  ; V-blank

  ; BG and sprites must use different pattern tables.
  ;;     VPHBSINN
  ;ldx #%10010000 ; This way around makes the IRQ fire at the start of a scanline instead
  ;               ; of in the middle of H-blank.
  ;     VPHBSINN
  ldx #%10001000 ; This way around makes the IRQ fire at the start of a scanline instead
                 ; of in the middle of H-blank.
  stx $2000 ; PPUCTRL

  inc FRAME_COUNT

  ; Update the selector
  lda #$28
  sta $2006
  lda #$0C
  clc
  adc MENU_POSITION
  sta $2006
  lda #$7F ; Arrow
  sta $2007
  lda #$28
  sta $2006
  lda #$0C
  clc
  adc MENU_POSITION
  eor #$20
  sta $2006
  lda #$50 ; Blank
  sta $2007

  ; Reset PPUSCROLL
  bit $2002
  lda #$00
  sta $2005 ; X scroll
  lda #$C0
  sta $2005 ; Y scroll

  ; -------------- Joypad input --------------

  lda BUTTONS
  sta PREV_BUTTONS
  jsr read_joypad

  ; Write sprite data to OAM
  lda #$00
  sta $2003 ; OAMADDR
  lda #(SPRITES_STAGING>>8)
  sta $4014 ; OAMDMA
  ; DMA wait..

  ; Set the BG palette
  lda #$3F
  sta $2006
  lda #$00
  sta $2006
  ldx #$00
  lda FRAME_COUNT
  asl
  and #$70
  tay
- lda ramps,y
  sta $2007
  inx
  iny
  cpx #$10
  bne -

  ; -------------- Handle inputs --------------

  ; Start
  lda #(1<<4)
  bit BUTTONS
  beq +
  lda #(1<<4)
  bit PREV_BUTTONS
  bne +
  lda MENU_POSITION
  bne ++
  rts
++
  jsr infoscreen
  jmp titlescreen
+

  ; Select
;  lda #(1<<5)
;  bit BUTTONS
;  beq +
;  lda #(1<<5)
;  bit PREV_BUTTONS
;  bne +
;  ; Reset the level
;  jsr infoscreen
;+

  ; Down
  lda #(1<<2)
  bit BUTTONS
  beq +
  lda #$20
  sta MENU_POSITION
+

  ; Up
  lda #(1<<3)
  bit BUTTONS
  beq +
  lda #$00
  sta MENU_POSITION
+

  ; Enable BG+sprites
  ldx #%00011000
  stx $2001 ; PPUMASK

  sta $E000 ; MMC3 IRQ acknowledge + disable

  ; Enable MMC3 IRQ
  lda #$40 ; Reserve the top lines
  sta $C000 ; IRQ latch
  sta $C001 ; IRQ reload
  sta $E001 ; IRQ enable

  cli ; Enable interrupts

  ; Clear PPUADDR latch by reading PPUSTATUS
  bit $2002

  ; Prepare for IRQ sequence
  ldy $00
  ldx $01
  lda #$02
  sta $FF

  ; First part
  lda #$08
  sta $2006 ; Nametable number << 2 (that is: $00, $04, $08, or $0C) to $2006
  lda #$00
  sty $2005 ; Y to $2005

  ; X, Y, and A registers must be preserved from now until the IRQ sequence is done.

  ; Spinwait until the 64B (2B per scanline) sequence buffer has been fully processed.
- bit $FF
  bvc -

  sei ; Disable interrupts
  sta $E000 ; MMC3 IRQ acknowledge + disable

  jmp titlescreen_loop


  ; -------------- Information screen --------------

infoscreen

  lda #$00
  sta $2001 ; Disable rendering

  ; MMC3: Set mirroring to horizontal
  lda #$01
  sta $A000

  sei ; Disable interrupts

  ; MMC3: Set charbanks
  stx $E000 ; Disable scanline counter interrupts
  ldx #$00
  ldy #$00
  stx $8000 ; Select R0
  sty $8001 ; Set CHR bank 0 at $0000-$07FF
  iny
  iny       ; Y = 2
  inx       ; X = 1
  stx $8000 ; Select R1
  sty $8001 ; Set CHR bank 2 at $0800-$0FFF

  iny
  iny       ; Y = 4
  inx       ; X = 2
  stx $8000 ; Select R2
  sty $8001 ; Set CHR bank 4 at $1000-$13FF
  iny       ; Y = 5
  inx       ; X = 3
  stx $8000 ; Select R3
  sty $8001 ; Set CHR bank 5 at $1400-$17FF
  iny       ; Y = 6
  inx       ; X = 4
  stx $8000 ; Select R4
  sty $8001 ; Set CHR bank 6 at $1800-$1BFF
  iny       ; Y = 7
  inx       ; X = 5
  stx $8000 ; Select R5
  sty $8001 ; Set CHR bank 7 at $1C00-$1FFF

  ldy #$00
  inx       ; X = 6
  stx $8000 ; Select R6
  sty $8001 ; Set PRG bank 0 at $8000-$9FFF
  iny       ; Y = 1
  inx       ; X = 7
  stx $8000 ; Select R7
  sty $8001 ; Set PRG bank 1 at $A000-$BFFF


  ; Clear PPUADDR latch by reading PPUSTATUS
  bit $2002

  ; Wait for vertical blank.
;- bit $2002
;  bpl -

  ;     VPHBSINN
  ldx #%10011000
  stx $2000 ; PPUCTRL

  ; Show nothing for one frame.
  ldx #%00000000
  stx $2001 ; PPUMASK

  ; Clear the zeropage
  ldx #$00
  txa
- sta $00,x
  inx
  bne -

  ; Clear the ingame variables
  ldx #$30
- dex
  sta $0550,x
  bne -

  ; Set up info nametables
  lda #$20
  sta $2006
  lda #$00
  sta $2006
  ldx #$00
!for i, 0, 3 {
- lda INFO_NAMETABLE2+i*256,x
  sta $2007
  inx
  bne -
}
  lda #$28
  sta $2006
  lda #$00
  sta $2006
!for i, 0, 3 {
- lda INFO_NAMETABLE+i*256,x
  sta $2007
  inx
  bne -
}

  ; Copy sprites initial state to staging area
  ldx #$00
- lda INFO_SPRITES,x
  sta SPRITES_STAGING,x
  inx
  bne -

  ldx #1
  jsr init_music

  jsr read_joypad
  lda BUTTONS
  sta PREV_BUTTONS

  ; ----------------------------------------------------------

infoscreen_loop

  jsr update_music

  ; Wait for NMI
  lda NMI_COUNTER
- cmp NMI_COUNTER
  beq -

  ; Set the BG palette
  lda #$3F
  sta $2006
  lda #$00
  sta $2006
  lda #$04
  sta $2007
  lda #$1D
  sta $2007
  lda #$10
  sta $2007
  lda #$20
  sta $2007

  ; Set the sprites palette
  lda #$3F
  sta $2006
  lda #$10
  sta $2006
  lda #$04 ; Aliased to $3F00
  sta $2007
  lda #$15
  sta $2007
  lda #$15
  sta $2007
  lda #$15
  sta $2007

  ; Workaround for potential palette corruption bug
  lda #$3F
  sta $2006
  lda #$00
  sta $2006
  sta $2006
  sta $2006

  ; Reset PPUSCROLL
  bit $2002
  lda #$00
  sta $2005 ; X scroll
  lda SCROLL_POSITION
  sta $2005 ; Y scroll

  ; ----------------------------------------------------------
  ; V-blank

  sta $E000 ; MMC3 IRQ acknowledge + disable

  ; Enable BG+sprites
  ldx #%00011000
  stx $2001 ; PPUMASK

  ; -------------- Joypad input --------------

  lda BUTTONS
  sta PREV_BUTTONS
  jsr read_joypad

  ; Write sprite data to OAM
  lda #$00
  sta $2003 ; OAMADDR
  lda #(SPRITES_STAGING>>8)
  sta $4014 ; OAMDMA
  ; DMA wait..

  ; -------------- Handle inputs --------------

  ; Start
  lda #(1<<4)
  bit BUTTONS
  beq +
  lda #(1<<4)
  bit PREV_BUTTONS
  bne +
  rts
+

  ; Down
  lda #(1<<2)
  bit BUTTONS
  beq +
  inc SCROLL_POSITION
  lda SCROLL_POSITION
  cmp #240
  bne +
  dec SCROLL_POSITION
+

  ; Up
  lda #(1<<3)
  bit BUTTONS
  beq +
  lda SCROLL_POSITION
  beq +
  dec SCROLL_POSITION
+

  ; Update sprite positions
  ldx #(31*4)
-
  ; Back layer
  lda SPRITES_STAGING+3,x
  sec
  sbc #3
  sta SPRITES_STAGING+3,x
  ; Front layer
  lda SPRITES_STAGING+128+3,x
  sec
  sbc #6
  sta SPRITES_STAGING+128+3,x
!for i, 0, 3 {
  dex
}
  bpl -


  inc FRAME_COUNT

  jmp infoscreen_loop

  ; -----------------------------

read_joypad
  ; https://www.nesdev.org/wiki/Controller_reading_code
; At the same time that we strobe bit 0, we initialize the ring counter
; so we're hitting two birds with one stone here
    lda #$01
    ; While the strobe bit is set, buttons will be continuously reloaded.
    ; This means that reading from JOYPAD1 will only return the state of the
    ; first button: button A.
    sta JOYPAD1
    sta BUTTONS
    lsr          ; now A is 0
    ; By storing 0 into JOYPAD1, the strobe bit is cleared and the reloading stops.
    ; This allows all 8 buttons (newly reloaded) to be read from JOYPAD1.
    sta JOYPAD1
readjoy_loop
    lda JOYPAD1
    lsr          ; bit 0 -> Carry
    rol BUTTONS  ; Carry -> bit 0; bit 7 -> Carry
    bcc readjoy_loop
  rts

init_music

  ; Switch PRG bank windows 0 to the music data
  ;lda #6
  ;sta $8000 ; Select R6
  ;lda #2
  ;sta $8001 ; Set PRG bank 2 at $8000-$9FFF

	txa
	jsr FamiToneMusicPlay

  ; Switch PRG bank windows 0 to the main program data
  ;lda #6
  ;sta $8000 ; Select R6
  ;lda #0
  ;sta $8001 ; Set PRG bank 0 at $8000-$9FFF

  rts

update_music

  ; Switch PRG bank windows 0 to the music data
  ;lda #6
  ;sta $8000 ; Select R6
  ;lda #2
  ;sta $8001 ; Set PRG bank 2 at $8000-$9FFF

  jsr FamiToneUpdate

  ; Switch PRG bank windows 0 to the main program data
  ;lda #6
  ;sta $8000 ; Select R6
  ;lda #0
  ;sta $8001 ; Set PRG bank 0 at $8000-$9FFF

  rts

; Y = Table offset
; X = Length of string
make_string_nametable
- lda STRINGS,y
  sta $2007
  iny
  dex
  bne -
  rts

STRINGS
!convtab "acme_char_table_titlescreen.bin"
string_1_begin
  !text "(C)2025 CLOCKWORK CATS"
string_1_end
string_2_begin
  !text "PLAY"
string_2_end
string_3_begin
  !text "INFO"
string_3_end

hiders
;     Y   Tile Attrib.    X
!byte 64, $50, %00100000, 64
!byte 72, $50, %00100000, 64
!byte 80, $50, %00100000, 64
!byte 88, $50, %00100000, 64

!byte 64, $50, %00100000, 64+120
!byte 72, $50, %00100000, 64+120
!byte 80, $50, %00100000, 64+120
!byte 88, $50, %00100000, 64+120

  RAMP_SIDE_A_0 = $01
  RAMP_SIDE_A_1 = $11
  RAMP_SIDE_A_2 = $21
  RAMP_SIDE_A_3 = $31
  RAMP_SIDE_A_4 = $31
  RAMP_SIDE_A_5 = $21
  RAMP_SIDE_A_6 = $11
  RAMP_SIDE_A_7 = $01

  RAMP_SIDE_B_0 = $3C
  RAMP_SIDE_B_1 = $2C
  RAMP_SIDE_B_2 = $1C
  RAMP_SIDE_B_3 = $0C
  RAMP_SIDE_B_4 = $0C
  RAMP_SIDE_B_5 = $1C
  RAMP_SIDE_B_6 = $2C
  RAMP_SIDE_B_7 = $3C

ramps
; Frame 0
!byte $20, RAMP_SIDE_B_0, RAMP_SIDE_B_0, RAMP_SIDE_B_0 ; Palette 0 - Blank B
!byte $20, RAMP_SIDE_A_0, $20, RAMP_SIDE_A_0 ; Palette 1 - CYBER and Blank A
!byte $20, $20, RAMP_SIDE_B_0, RAMP_SIDE_B_0 ; Palette 2 - COASTER
!byte $20, $00, $10, $1D ; Palette 3 - Everything else
; Frame 1
!byte $20, RAMP_SIDE_B_1, RAMP_SIDE_B_1, RAMP_SIDE_B_1 ; Palette 0 - Blank B
!byte $20, RAMP_SIDE_A_1, $20, RAMP_SIDE_A_1 ; Palette 1 - CYBER and Blank A
!byte $20, $20, RAMP_SIDE_B_1, RAMP_SIDE_B_1 ; Palette 2 - COASTER
!byte $20, $00, $10, $1D ; Palette 3 - Everything else
; Frame 2
!byte $20, RAMP_SIDE_B_2, RAMP_SIDE_B_2, RAMP_SIDE_B_2 ; Palette 0 - Blank B
!byte $20, RAMP_SIDE_A_2, $20, RAMP_SIDE_A_2 ; Palette 1 - CYBER and Blank A
!byte $20, $20, RAMP_SIDE_B_2, RAMP_SIDE_B_2 ; Palette 2 - COASTER
!byte $20, $00, $10, $1D ; Palette 3 - Everything else
; Frame 3
!byte $20, RAMP_SIDE_B_3, RAMP_SIDE_B_3, RAMP_SIDE_B_3 ; Palette 0 - Blank B
!byte $20, RAMP_SIDE_A_3, $20, RAMP_SIDE_A_3 ; Palette 1 - CYBER and Blank A
!byte $20, $20, RAMP_SIDE_B_3, RAMP_SIDE_B_3 ; Palette 2 - COASTER
!byte $20, $00, $10, $1D ; Palette 3 - Everything else
; Frame 4
!byte $20, RAMP_SIDE_B_4, RAMP_SIDE_B_4, RAMP_SIDE_B_4 ; Palette 0 - Blank B
!byte $20, RAMP_SIDE_A_4, $20, RAMP_SIDE_A_4 ; Palette 1 - CYBER and Blank A
!byte $20, $20, RAMP_SIDE_B_4, RAMP_SIDE_B_4 ; Palette 2 - COASTER
!byte $20, $00, $10, $1D ; Palette 3 - Everything else
; Frame 5
!byte $20, RAMP_SIDE_B_5, RAMP_SIDE_B_5, RAMP_SIDE_B_5 ; Palette 0 - Blank B
!byte $20, RAMP_SIDE_A_5, $20, RAMP_SIDE_A_5 ; Palette 1 - CYBER and Blank A
!byte $20, $20, RAMP_SIDE_B_5, RAMP_SIDE_B_5 ; Palette 2 - COASTER
!byte $20, $00, $10, $1D ; Palette 3 - Everything else
; Frame 6
!byte $20, RAMP_SIDE_B_6, RAMP_SIDE_B_6, RAMP_SIDE_B_6 ; Palette 0 - Blank B
!byte $20, RAMP_SIDE_A_6, $20, RAMP_SIDE_A_6 ; Palette 1 - CYBER and Blank A
!byte $20, $20, RAMP_SIDE_B_6, RAMP_SIDE_B_6 ; Palette 2 - COASTER
!byte $20, $00, $10, $1D ; Palette 3 - Everything else
; Frame 7
!byte $20, RAMP_SIDE_B_7, RAMP_SIDE_B_7, RAMP_SIDE_B_7 ; Palette 0 - Blank B
!byte $20, RAMP_SIDE_A_7, $20, RAMP_SIDE_A_7 ; Palette 1 - CYBER and Blank A
!byte $20, $20, RAMP_SIDE_B_7, RAMP_SIDE_B_7 ; Palette 2 - COASTER
!byte $20, $00, $10, $1D ; Palette 3 - Everything else

irq2
!binary "irq2.bin"
irq2_end

