
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include "mem.h"
#include "defs.h"

static uint8_t* mem_hunk = NULL;
static uint8_t* mem_hunk_pos = NULL;
static uint8_t* mem_hunk_end = NULL;

uint32_t mem_hunk_highwater = 0;

void hunkInit()
{
  mem_hunk = malloc(MEM_HUNK_SIZE);
  mem_hunk_end = mem_hunk + MEM_HUNK_SIZE;
  mem_hunk_pos = mem_hunk;
  printf("Hunk: Initialized with %u bytes.\n", MEM_HUNK_SIZE);
}

uint8_t* hunkAlloc(uint32_t size)
{
  uint8_t* p = mem_hunk_pos;
  mem_hunk_pos += (size + 15u) & ~15u;
  assert(mem_hunk_pos < mem_hunk_end);
  mem_hunk_highwater = MAX(mem_hunk_highwater, mem_hunk_pos - mem_hunk);
  //printf("Hunk: Allocated %u bytes.\n", size);
  return p;
}

void hunkMark(hunk_marker_t* marker)
{
  marker->pos = mem_hunk_pos;
}

void hunkFree(hunk_marker_t* marker)
{
  mem_hunk_pos = marker->pos;
}

