  ; irq2.bin
  * = $0500 ; System RAM
  ; IRQ handler

  ; AAA AA AABBB BBBBB
  ; yyy NN YYYYY XXXXX
  ; ||| || ||||| +++++-- coarse X scroll
  ; ||| || +++++-------- coarse Y scroll
  ; ||| ++-------------- nametable select
  ; +++----------------- fine Y scroll

  ; Second part
  sta $2005 ; X to $2005 (always 0)
  stx $2006 ; Low byte of nametable address to $2006, which is ((Y & $F8) << 2) | (X >> 3)

  sta $C000 ; MMC3 IRQ latch

  sty $E000 ; MMC3 IRQ acknowledge + disable
  sty $E001 ; MMC3 IRQ enable

  ldx $FF

  ; First part A
  lda $80,x
  sta $2006 ; Nametable number << 2 (that is: $00, $04, $08, or $0C) to $2006

  ldy $00,x
  lda $01,x
  inx
  inx
  stx $FF
  tax

  ; First part B
  sty $2005 ; Y to $2005

  lda #$00
  rti
