  * = $8000

  ; ROM
  LOG_TABLE = $C000
  EXP_TABLE = $C100
  RECT_ARRAY = $C200
  LOG_Z_TABLE = $C300

  ; RAM
  ; Zeropage (first 32 bytes are for variables, rest is reserved)
  RECT_ARRAY_INDEX = $00
  CAM_X = $01
  CAM_Y = $02
  LOG_Z = $03
  TEMP_1 = $04
  STRIP_BOUNDS = $05
  Z = $15
  COUNT = $16

  ; --- Upper ---

!for i, 1, 3 {

!if i = 1 {
  lda STRIP_BOUNDS+i*4+2 ; min_y
} else {
  lda STRIP_BOUNDS+i*4+2 ; min_y
  sec
  sbc STRIP_BOUNDS+(i-1)*4+2 ; min_y
}

  sta TEMP_1
  ; Divide by 8
  lsr
  lsr
  lsr
  beq ++

  ; Middle scrollpoints (if any)
  sta COUNT
- lda #8
  sta $00,x
  inx
  lda #((i-1)<<5)
  sta $00,x
  inx
  dec COUNT
  bne -

++
  ; End scrollpoint
  lda TEMP_1
  and #7
  beq +
  sta $00,x
  inx
  lda #((i-1)<<5)
  sta $00,x
  inx
+
}

  ; --- Lower ---

!for i, 3, 0 {

!if i = 0 {
  lda #223
  sec
  sbc STRIP_BOUNDS+1*4+2 ; min_y
} else {
!if i = 3 {
  lda STRIP_BOUNDS+i*4+3 ; max_y
  sec
  sbc STRIP_BOUNDS+i*4+2 ; min_y
} else {
  lda STRIP_BOUNDS+i*4+3 ; max_y
  sec
  sbc STRIP_BOUNDS+(i+1)*4+3 ; max_y
}
}

  sta TEMP_1
  ; Divide by 8
  lsr
  lsr
  lsr
  beq ++

  ; Middle scrollpoints (if any)
  sta COUNT
- lda #8
  sta $00,x
  inx
  lda #(i<<5)
  sta $00,x
  inx
  dec COUNT
  bne -

++
  ; End scrollpoint
  lda TEMP_1
  and #7
  beq +
  sta $00,x
  inx
  lda #(i<<5)
  sta $00,x
  inx
+
}
