  ; strips.bin
  * = $0300 ; System RAM

  ; RAM
  ; Zeropage (first 32 bytes are for variables, rest is reserved)
  TEMP_1 = $04
  STRIP_BOUNDS = $05 ; Bounds are inclusive-exclusive.
  Z = $15
  COUNT = $16
  TEMP_2 = $17
  FLIP_POINT_COARSE = $18
  FLIP_POINT_FINE = $19

  ; $20 - $7F : Nametable staging
  ; $80 - $D0 : Scrollpoints array

  ; -------------- Nametables --------------

  ; Splat the layers

  ; Second layer
  ldx #$00

  lda STRIP_BOUNDS+1*4+0 ; min_x
  cmp STRIP_BOUNDS+1*4+1 ; max_x
  bcs second_layer_occluded

  sec
  sbc FLIP_POINT_FINE
+ sta TEMP_1

  ; Divide by 8
  lsr
  lsr
  lsr
  beq +
  sta TEMP_2

  ; Outer left
  lda #$2C
- sta $20,x
  inx
  cpx TEMP_2
  bne -
+

  ; Apply the splat
  lda TEMP_1
  and #7
  ora #$F0
  sta (+)+2 ; Upper byte of stripsplat table address
+ lda $002C
  sta $20,x
  inx

  cpx FLIP_POINT_COARSE
  bcs +
  beq +

  ; Inner left
  lda #$08
- sta $20,x
  inx
  cpx FLIP_POINT_COARSE
  bne -
+

  ldx FLIP_POINT_COARSE

  lda STRIP_BOUNDS+1*4+1 ; max_x
  sec
  sbc FLIP_POINT_FINE
+ sta TEMP_1

  ; Divide by 8
  lsr
  lsr
  lsr
  sta TEMP_2

  cpx TEMP_2
  bcs +
  beq +

  ; Inner right
  lda #$35
- sta $20,x
  inx
  cpx TEMP_2
  bne -
+

  ; Apply the splat
  lda TEMP_1
  and #7
  ora #$F0
  sta (+)+2 ; Upper byte of stripsplat table address
+ lda $002D
  sta $20,x
  inx

  cpx #32
  bcs +
  beq +

  ; Outer right
  lda #$2D
- sta $20,x
  inx
  cpx #32
  bne -
+

  jmp ++
second_layer_occluded
  cpx FLIP_POINT_COARSE
  bcs +
  beq +

  ; Outer left
  lda #$2C
- sta $20,x
  inx
  cpx FLIP_POINT_COARSE
  bne -

  cpx #32
  bcs +
  beq +

  ; Outer right
  lda #$2D
- sta $20,x
  inx
  cpx #32
  bne -

++
  ; Now, x == 32


  ; Third layer
  ldx #$00

  lda STRIP_BOUNDS+2*4+0 ; min_x
  cmp STRIP_BOUNDS+2*4+1 ; max_x
  bcs third_layer_occluded

  sec
  sbc FLIP_POINT_FINE
+ sta TEMP_1

  ; Divide by 8
  lsr
  lsr
  lsr
  beq +
  sta TEMP_2

  ; Outer left
- lda $20,x ; x >= 32
  sta $40,x
  inx
  cpx TEMP_2
  bne -
+

  ; Apply the splat
  lda $20,x ; Previous strip
  sta (+)+1 ; Lower byte of stripsplat table address
  lda TEMP_1
  and #7
  ora #$F0
  sta (+)+2 ; Upper byte of stripsplat table address
+ lda $0000
  sta $40,x
  inx

  cpx FLIP_POINT_COARSE
  bcs +
  beq +

  ; Inner left
  lda #$FF
- sta $40,x
  inx
  cpx FLIP_POINT_COARSE
  bne -
+

  ldx FLIP_POINT_COARSE

  lda STRIP_BOUNDS+2*4+1 ; max_x
  sec
  sbc FLIP_POINT_FINE
+ sta TEMP_1

  ; Divide by 8
  lsr
  lsr
  lsr
  sta TEMP_2

  cpx TEMP_2
  bcs +
  beq +

  ; Inner right
  lda #$59
- sta $40,x
  inx
  cpx TEMP_2
  bne -
+

  ; Apply the splat
  lda $20,x ; Previous strip
  sta (+)+1 ; Lower byte of stripsplat table address
  lda TEMP_1
  and #7
  ora #$F0
  sta (+)+2 ; Upper byte of stripsplat table address
+ lda $0000
  sta $40,x
  inx

  cpx #32
  bcs +
  beq +

  ; Outer right
- lda $20,x ; x >= 32
  sta $40,x
  inx
  cpx #32
  bne -
+

  jmp ++
third_layer_occluded
  cpx FLIP_POINT_COARSE
  bcs +
  beq +

  ; Outer left
- lda $20,x
  sta $40,x
  inx
  cpx FLIP_POINT_COARSE
  bne -
+
  cpx #32
  bcs +
  beq +

  ; Outer right
- lda $20,x
  sta $40,x
  inx
  cpx #32
  bne -
+
++
  ; Now, x == 32


  ; Fourth layer
  ldx #$00

  lda STRIP_BOUNDS+3*4+0 ; min_x
  cmp STRIP_BOUNDS+3*4+1 ; max_x
  bcs fourth_layer_occluded

  cpx FLIP_POINT_COARSE
  beq +

  ; Left (only outer, no inner)
- lda $40,x ; x >= 64
  sta $60,x
  inx
  cpx FLIP_POINT_COARSE
  bne -
+

  ldx FLIP_POINT_COARSE

  lda STRIP_BOUNDS+3*4+1 ; max_x
  sec
  sbc FLIP_POINT_FINE
+ sta TEMP_1

  ; Divide by 8
  lsr
  lsr
  lsr
  sta TEMP_2

  cpx TEMP_2
  bcs +
  beq +

  ; Inner right
  lda #$D1
- sta $60,x
  inx
  cpx TEMP_2
  bne -
+

  ; Apply the splat
  lda $40,x ; Previous strip
  sta (+)+1 ; Lower byte of stripsplat table address
  lda TEMP_1
  and #7
  ora #$F0
  sta (+)+2 ; Upper byte of stripsplat table address
+ lda $0000
  sta $60,x
  inx

  cpx #32
  bcs +
  beq +

  ; Outer right
- lda $40,x ; x >= 64
  sta $60,x
  inx
  cpx #32
  bne -
+

  jmp ++
fourth_layer_occluded
  cpx FLIP_POINT_COARSE
  bcs +
  beq +

  ; Outer left
- lda $40,x
  sta $60,x
  inx
  cpx FLIP_POINT_COARSE
  bne -
+

  cpx #32
  bcs +
  beq +

  ; Outer right
- lda $40,x
  sta $60,x
  inx
  cpx #32
  bne -
+
++
  ; Now, x == 32

  ; The nametables are done.
  rts
