  ; reset.bin
  * = $FF00

  ; Reset
  sei ; Disable interrupts
  cld ; Disable decimal mode
  ldx #$40
  stx $4017 ; Disable APU frame IRQ
  ldx #$FF
  txs       ; Set the stack pointer
  inx       ; X = 0
  stx $2000 ; Disable NMI
  stx $2001 ; Disable rendering
  stx $4010 ; Disable DMC IRQs

  ; MMC3-specific:

  stx $E000 ; Disable scanline counter interrupts
  ldy #$00
  stx $8000 ; Select R0
  sty $8001 ; Set CHR bank 0 at $0000-$07FF
  iny
  iny       ; Y = 2
  inx       ; X = 1
  stx $8000 ; Select R1
  sty $8001 ; Set CHR bank 2 at $0800-$0FFF

  iny
  iny       ; Y = 4
  inx       ; X = 2
  stx $8000 ; Select R2
  sty $8001 ; Set CHR bank 4 at $1000-$13FF
  iny       ; Y = 5
  inx       ; X = 3
  stx $8000 ; Select R3
  sty $8001 ; Set CHR bank 5 at $1400-$17FF
  iny       ; Y = 6
  inx       ; X = 4
  stx $8000 ; Select R4
  sty $8001 ; Set CHR bank 6 at $1800-$1BFF
  iny       ; Y = 7
  inx       ; X = 5
  stx $8000 ; Select R5
  sty $8001 ; Set CHR bank 7 at $1C00-$1FFF

  ldy #$00
  inx       ; X = 6
  stx $8000 ; Select R6
  sty $8001 ; Set PRG bank 0 at $8000-$9FFF
  iny       ; Y = 1
  inx       ; X = 7
  stx $8000 ; Select R7
  sty $8001 ; Set PRG bank 1 at $A000-$BFFF

  ; The vblank flag is in an unknown state after reset,
  ; so it is cleared here to make sure that the following loop
  ; does not exit immediately.
  bit $2002

  ; First of two waits for vertical blank to make sure that the
  ; PPU has stabilized.
- bit $2002
  bpl -

  ; Clear the 2KB of system RAM.
  ldx #$00
  txa
- sta $00,x
  sta $0100,x
  sta $0200,x
  sta $0300,x
  sta $0400,x
  sta $0500,x
  sta $0600,x
  sta $0700,x
  inx
  bne -

  ; Create a dummy IRQ handler
  lda #$40 ; RTI
  sta $0500

  ; Copy stripgen routine from ROM to RAM - assume it is exactly 512 bytes in size.
  ldx #$00
- lda $F800,x
  sta $0300,x
  inx
  bne -
- lda $F900,x
  sta $0400,x
  inx
  bne -

  ; Wait for vertical blank.
- bit $2002
  bpl -

  ; Clear all of palette RAM
  lda #$3F
  sta $2006
  lda #$00
  sta $2006
  lda #$1D
  ldx #$20
- sta $2007
  dex
  bne -

  ; Workaround for potential palette corruption bug
  lda #$3F
  sta $2006
  lda #$00
  sta $2006
  sta $2006
  sta $2006

  ; Clear PPUADDR latch by reading PPUSTATUS
  bit $2002
  ; Clear VRAM $2000-$2FFF (i.e. all of it)
  lda #$20
  sta $2006 ; PPUADDR
  lda #$00
  sta $2006 ; PPUADDR
  ldy #$10
  ldx #$00
  txa
- sta $2007
  dex
  bne -
  dey
  bne -

  jmp $CB00