  * = $A100

  TEMP              = $04
  STRIP_BOUNDS      = $05 ; Bounds are inclusive-exclusive.

  ; Variables overlaid with the nametable staging area
  PICKUP_XPROJ      = $20
  PICKUP_YPROJ      = $21
  PICKUP_FRAME      = $22
  METATILE_ADDRESS  = $23 ; 2B
  PICKUP_BOUNDS     = $25 ; 4B

  SPRITES_STAGING   = $0200

  TEMP_1            = $055D


  PICKUP_SPRITE_PALETTE = 2

  ; Bonus pickup item sprites

  inc PICKUP_BOUNDS+0 ; min_x

  ; Calculate sprite metatile address
  lda #$00
  sta METATILE_ADDRESS+1
  lda PICKUP_FRAME
  clc
!for i, 0, 3 {
  rol
  rol METATILE_ADDRESS+1
}
  sta METATILE_ADDRESS+0
  lda METATILE_ADDRESS+1
  clc
  adc #(metatiles>>8)
  sta METATILE_ADDRESS+1

  ldx #$10

  ; Top guard
  lda #8
  sta TEMP
- lda PICKUP_BOUNDS+2 ; min_y
  sec
  sbc #8
  sta SPRITES_STAGING,x ; Y
  inx
  lda #$FF
  sta SPRITES_STAGING,x ; Tile index
  inx
  lda #%00100000 ; Behind-background priority
  sta SPRITES_STAGING,x ; Attributes
  inx
  lda #$00
  sta SPRITES_STAGING,x ; X
  inx
  dec TEMP
  bne -

  ; Bottom guard
  lda #8
  sta TEMP
- lda PICKUP_BOUNDS+3 ; max_y
  sta SPRITES_STAGING,x ; Y
  inx
  lda #$FF
  sta SPRITES_STAGING,x ; Tile index
  inx
  lda #%00100000 ; Behind-background priority
  sta SPRITES_STAGING,x ; Attributes
  inx
  lda #$00
  sta SPRITES_STAGING,x ; X
  inx
  dec TEMP
  bne -

  ; Left Guard
  lda #4
  sta TEMP
  lda PICKUP_YPROJ
  sec
  sbc #16
  sta TEMP_1
- lda TEMP_1
  sta SPRITES_STAGING,x ; Y
  clc
  adc #8
  sta TEMP_1
  inx
  lda #$FF
  sta SPRITES_STAGING,x ; Tile index
  inx
  lda #%00100000 ; Behind-background priority
  sta SPRITES_STAGING,x ; Attributes
  inx
  lda PICKUP_BOUNDS+0 ; min_x
  sec
  sbc #8
  sta SPRITES_STAGING,x ; X
  inx
  dec TEMP
  bne -

  ; Right Guard
  lda #4
  sta TEMP
  lda PICKUP_YPROJ
  sec
  sbc #16
  sta TEMP_1
- lda TEMP_1
  sta SPRITES_STAGING,x ; Y
  clc
  adc #8
  sta TEMP_1
  inx
  lda #$FF
  sta SPRITES_STAGING,x ; Tile index
  inx
  lda #%00100000 ; Behind-background priority
  sta SPRITES_STAGING,x ; Attributes
  inx
  lda PICKUP_BOUNDS+1 ; max_x
  clc
  adc #1
  sta SPRITES_STAGING,x ; X
  inx
  dec TEMP
  bne -

  ; The pickup sprite itself
  ; Note that the sprite indices here are hardcoded.

  ldx #$00
-
  ; Default to blank
  lda #%00100000 ; Behind-background priority
  sta SPRITES_STAGING+$82,x ; Attributes
  lda #$00
  sta SPRITES_STAGING+$81,x ; Tile index
  sta SPRITES_STAGING+$83,x ; X
  sta SPRITES_STAGING+$80,x ; Y

  lda PICKUP_YPROJ
  clc
  adc metasprite_table+0,x

  sta SPRITES_STAGING+$80,x ; Y
  cmp PICKUP_BOUNDS+3 ; max_y
  bcs +
  adc #8
  cmp PICKUP_BOUNDS+2 ; min_y
  bcc +

  lda METATILE_ADDRESS+0
  and #$F0
  ora metasprite_table+1,x
  sta METATILE_ADDRESS+0
  stx TEMP
  ldx #$00
  lda (METATILE_ADDRESS,x)
  ldx TEMP
  sta SPRITES_STAGING+$81,x ; Tile index

  lda PICKUP_XPROJ
  clc
  adc metasprite_table+2,x

  sta SPRITES_STAGING+$83,x ; X
  cmp PICKUP_BOUNDS+1 ; max_x
  bcs +
  adc #8
  cmp PICKUP_BOUNDS+0 ; min_x
  bcc +

  lda metasprite_table+3,x
  sta SPRITES_STAGING+$82,x ; Attributes
+

  inx
  inx
  inx
  inx
  cpx #(16*4)
  bne -

  rts


metasprite_table
!for i, 0, 15 {
!if i < 8 {
  !byte (-16+((i/2)&1)*8)
} else {
  !byte (8-((i/2)&1)*8)
}
  !byte i
!if (i&7) < 4 {
  !byte (-16+(i&1)*8)
} else {
  !byte (8-(i&1)*8)
}
!if i/4 = 0 {
  !byte (%00000000 | ((i/4)<<6) | 1)
} else if i/4 = 1 {
  !byte (%00000000 | ((i/4)<<6) | 2)
} else if i/4 = 2 {
  !byte (%00000000 | ((i/4)<<6) | 2)
} else if i/4 = 3 {
  !byte (%00000000 | ((i/4)<<6) | 3)
}
}


!align 255, 0
metatiles
!binary "pickup_metatiles.bin"