#include <SDL.h>
#include <assert.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "input.h"


#define SYS_JOY_DEADZONE 0.25f  /**< @brief Joypad deadzone from 0.0 to 1.0. */

#define BTN_X			SDLK_SPACE
#define BTN_A			SDLK_LCTRL
#define BTN_B			SDLK_LALT
#define BTN_Y			SDLK_LSHIFT
#define BTN_L			SDLK_TAB
#define BTN_R			SDLK_BACKSPACE
#define BTN_START		SDLK_RETURN
#define BTN_SELECT		SDLK_ESCAPE


SDL_Joystick *sys_joypad = NULL;  /**< @brief The current joypad. */


int sys_inputs[SYS_NUM_INPUTS];
int sys_inputs_previous[SYS_NUM_INPUTS];

bool_t sysInitialise(void)
{
  sys_joypad = SDL_JoystickOpen(0);
  return TRUE;
}

bool_t sysUpdateInput(void)
{
  Uint8 *key = SDL_GetKeyState(NULL);
  int i = 0;

  if (!key && !sys_joypad) { return FALSE; }

  for (i = 0; i < SYS_NUM_INPUTS; i++)
  {
    sys_inputs_previous[i] = sys_inputs[i];
    sys_inputs[i] = 0;
  }

  if (key)
  {
    if (key[SDLK_ESCAPE]) { return FALSE; }
    sys_inputs[SYS_INPUT_LEFT]  = key[SDLK_LEFT];
    sys_inputs[SYS_INPUT_RIGHT] = key[SDLK_RIGHT];
    sys_inputs[SYS_INPUT_MENU_UP]  = key[SDLK_UP];
    sys_inputs[SYS_INPUT_MENU_DOWN] = key[SDLK_DOWN];
    sys_inputs[SYS_INPUT_UP]  = key[SDLK_UP];
    sys_inputs[SYS_INPUT_DOWN] = key[SDLK_DOWN];
    sys_inputs[SYS_INPUT_MENU_CHOOSE] = key[BTN_B];
    sys_inputs[SYS_INPUT_JUMP]  = key[BTN_A];
    sys_inputs[SYS_INPUT_FIRE]  = key[BTN_B];
    sys_inputs[SYS_INPUT_GRAB]  = key[SDLK_DOWN];
    sys_inputs[SYS_INPUT_DROP]  = key[BTN_L];
    sys_inputs[SYS_INPUT_PAUSE]  = key[BTN_START];
  }

  if (sys_joypad)
  {
    float tmp = SDL_JoystickGetAxis(sys_joypad, 0) / 32768.0;
    if (tmp < -SYS_JOY_DEADZONE || tmp > SYS_JOY_DEADZONE)
    {
      if (sys_inputs[SYS_INPUT_LEFT]  < -tmp) { sys_inputs[SYS_INPUT_LEFT]  = 1; }
      if (sys_inputs[SYS_INPUT_RIGHT] < +tmp) { sys_inputs[SYS_INPUT_RIGHT] = 1; }
    }

    if (SDL_JoystickGetButton(sys_joypad, 0)) { sys_inputs[SYS_INPUT_JUMP] = 1; }
    if (SDL_JoystickGetButton(sys_joypad, 1)) { sys_inputs[SYS_INPUT_FIRE] = 1; }
    if (SDL_JoystickGetButton(sys_joypad, 2)) { sys_inputs[SYS_INPUT_GRAB] = 1; }
    if (SDL_JoystickGetButton(sys_joypad, 3)) { sys_inputs[SYS_INPUT_DROP] = 1; }
  }

  return TRUE;

}

