#ifndef __GAME_H__
#define __GAME_H__

#include "defs.h"

typedef struct
{
  float x;
  float y;
  float x_vel;
  float y_vel;
  float measured_speed;
  bool_t destroyed;
} player_t;

typedef struct 
{
  bool_t active;
  float posx, posy;
  uint32_t spawn_time;
  uint32_t detonation_time;
  uint32_t deactivate_time;
  bool_t detonated;
} mine_t;

typedef struct 
{
  bool_t active;
  float posx, posy;
  float dirx, diry;
} bullet_t;

typedef struct 
{
  float posx, posz;
  bool_t collected;
} piece_t;

typedef struct
{
  mine_t mines[MAX_MINES];
  int num_mines;
  bullet_t bullets[MAX_BULLETS];
  int num_bullets;
  piece_t pieces[MAX_PIECES];
  int num_pieces;
  int num_pieces_collected;
  int32_t level_timer;
  int32_t current_time_score;
  uint32_t next_frame;
  uint32_t frame_time;
  uint32_t start_level_time;
  bool_t timedout;
  uint32_t play_time;
  bool_t in_gameover_sequence;
  uint32_t gameover_sequence_time;
  uint32_t gameover_sequence_end_time;
  const char* announcement_string;
  uint32_t mine_spawn_interval;
  uint32_t next_mine_spawn_time;
  uint32_t next_interval_decrement_time;
} gamestate_t;


void resetLevel(player_t* player, gamestate_t* gs, uint32_t start_time);
void advanceGameFrame(renderstate_t* rs, player_t* player, gamestate_t* gs);

#endif // __GAME_H__