  * = $8000

  ; Constants
  WINDOW_YMIN = 32
  WINDOW_YMAX = 223

  ; ROM
  LOG_TABLE = $C000
  EXP_TABLE = $C100
  RECT_ARRAY = $C200
  LOG_Z_TABLE = $C300

  ; RAM
  ; Zeropage (first 32 bytes are for variables, rest is reserved)
  RECT_ARRAY_INDEX = $00
  CAM_X = $01
  CAM_Y = $02
  LOG_Z = $03
  TEMP_1 = $04
  STRIP_BOUNDS = $05 ; Bounds are inclusive-exclusive.
  Z = $15
  COUNT = $16
  SCANLINE = $17
  FLIP_POINT_COARSE = $18
  FLIP_POINT_FINE = $19

  ; $20 - $7F : Nametable staging
  ; $80 - $D0 : Scrollpoints array

  ; -------------- Projection and clipping --------------

  lda #$08
  sta FLIP_POINT_COARSE

!for i, 1, 3 {

  ; Fetch Log(Z)
  ldx Z
  lda LOG_Z_TABLE,x
  sta LOG_Z

  ; Load L
  ldx RECT_ARRAY_INDEX
  lda RECT_ARRAY,x
  inc RECT_ARRAY_INDEX

  ; Subtract camera X
  sec
  sbc CAM_X
  beq +
  sta TEMP_1

  ; Exp(Log(X)-Log(Z))
  tax
  lda LOG_TABLE,x
  sec
  sbc LOG_Z
  tax
  lda EXP_TABLE,x
  
  bit TEMP_1
  bpl +
  ; Negate A
  eor #$FF
  clc
  adc #1
+ clc
  adc #(128+4)

!if i > 1 {
  ; Clip against outer rectangle
  cmp STRIP_BOUNDS+(i-1)*4+0 ; min_x
  bcs +
  lda STRIP_BOUNDS+(i-1)*4+0 ; min_x
;+ cmp STRIP_BOUNDS+(i-1)*4+1 ; max_x
;  bcc +
;  lda STRIP_BOUNDS+(i-1)*4+1 ; max_x
}
+ sta STRIP_BOUNDS+i*4+0 ; min_x

  ; Load R
  ldx RECT_ARRAY_INDEX
  lda RECT_ARRAY,x
  inc RECT_ARRAY_INDEX

  ; Subtract camera X
  sec
  sbc CAM_X
  beq +
  sta TEMP_1

  ; Exp(Log(X)-Log(Z))
  tax
  lda LOG_TABLE,x
  sec
  sbc LOG_Z
  tax
  lda EXP_TABLE,x
  
  bit TEMP_1
  bpl +
  ; Negate A
  eor #$FF
  clc
  adc #1
+ clc
  adc #(128+4)

!if i > 1 {
  ; Clip against outer rectangle
  cmp STRIP_BOUNDS+(i-1)*4+1 ; max_x
  bcc +
  lda STRIP_BOUNDS+(i-1)*4+1 ; max_x
;+ cmp STRIP_BOUNDS+(i-1)*4+0 ; min_x
;  bcs +
;  lda STRIP_BOUNDS+(i-1)*4+0 ; min_x
}
+ sta STRIP_BOUNDS+i*4+1 ; max_x

  lda STRIP_BOUNDS+i*4+0 ; min_x
  cmp STRIP_BOUNDS+i*4+1 ; max_x
  bcs +
  sta FLIP_POINT_COARSE ; Temporary
+

  ; --- Upper ---

  ; Load T
  ldx RECT_ARRAY_INDEX
  lda RECT_ARRAY,x
  inc RECT_ARRAY_INDEX

  ; Subtract camera Y
  sec
  sbc CAM_Y
  beq +
  sta TEMP_1

  ; Exp(Log(Y)-Log(Z))
  tax
  lda LOG_TABLE,x
  sec
  sbc LOG_Z
  tax
  lda EXP_TABLE,x
  
  bit TEMP_1
  bpl +
  ; Negate A
  eor #$FF
  clc
  adc #1
+ clc
  adc #128

!if i > 1 {
  ; Clip against outer rectangle
  cmp STRIP_BOUNDS+(i-1)*4+3 ; max_y
  bcc +
  lda STRIP_BOUNDS+(i-1)*4+3 ; max_y
} else {
  ; Clip against the window
  cmp #WINDOW_YMAX
  bcc +
  lda #WINDOW_YMAX
}
+ sta STRIP_BOUNDS+i*4+2 ; min_y

  ; --- Lower ---

  ; Load B
  ldx RECT_ARRAY_INDEX
  lda RECT_ARRAY,x
  inc RECT_ARRAY_INDEX

  ; Subtract camera Y
  sec
  sbc CAM_Y
  beq +
  sta TEMP_1

  ; Exp(Log(Y)-Log(Z))
  tax
  lda LOG_TABLE,x
  sec
  sbc LOG_Z
  tax
  lda EXP_TABLE,x
  
  bit TEMP_1
  bpl +
  ; Negate A
  eor #$FF
  clc
  adc #1
+ clc
  adc #128

!if i > 1 {
  ; Clip against outer rectangle
  cmp STRIP_BOUNDS+(i-1)*4+3 ; max_y
  bcc +
  lda STRIP_BOUNDS+(i-1)*4+3 ; max_y
} else {
  ; Clip against the window
  cmp #WINDOW_YMAX
  bcc +
  lda #WINDOW_YMAX
}
+ sta STRIP_BOUNDS+i*4+3 ; max_y

!if i < 3 {
  lda #85
  clc
  adc Z
  sta Z
}
}

  ; -------------- Scrollpoints --------------

  ; Reserve top 32 scanlines for the HUD
  ldx #$00
  lda #31
  sta $80,x
  inx
  lda #(4<<5)
  sta $80,x
  inx

  lda #WINDOW_YMIN
  sta SCANLINE

!for i, 1, 3 {

  lda STRIP_BOUNDS+i*4+2 ; min_y
  sec
  sbc SCANLINE

  bcc +++

  sta TEMP_1
  ; Divide by 8
  lsr
  lsr
  lsr
  beq ++

  ; Middle scrollpoints (if any)
  sta COUNT
- lda #7
  sta $80,x
  inx
  lda #((i-1)<<5)
  sta $80,x
  inx
  dec COUNT
  bne -

++
  ; End scrollpoint
  lda TEMP_1
  and #7
  beq +
  sec
  sbc #1
  sta $80,x
  inx
  lda #((i-1)<<5)
  sta $80,x
  inx
+
  lda STRIP_BOUNDS+i*4+2 ; min_y
  sta SCANLINE
+++
}

  ; --- Lower ---

!for i, 3, 0 {

!if i = 0 {
  lda #WINDOW_YMAX
} else {
  lda STRIP_BOUNDS+i*4+3 ; max_y
}
  sec
  sbc SCANLINE

  bcc +++

  sta TEMP_1
  ; Divide by 8
  lsr
  lsr
  lsr
  beq ++

  ; Middle scrollpoints (if any)
  sta COUNT
- lda #7
  sta $80,x
  inx
  lda #(i<<5)
  sta $80,x
  inx
  dec COUNT
  bne -

++
  ; End scrollpoint
  lda TEMP_1
  and #7
  beq +
  sec
  sbc #1
  sta $80,x
  inx
  lda #(i<<5)
  sta $80,x
  inx
+
  lda STRIP_BOUNDS+i*4+3 ; max_y
  sta SCANLINE
+++
}

  ; Show the HUD for the remaining (16) scanlines
  lda #16
  sta $80,x
  inx
  lda #(4<<5)
  sta $80,x
  inx

  ; -------------- Nametables --------------

  lda FLIP_POINT_COARSE
  and #7
  sta FLIP_POINT_FINE
  lda FLIP_POINT_COARSE
  lsr
  lsr
  lsr
  sta FLIP_POINT_COARSE

  ; Nametable-generating routine is in RAM because it uses self-modifying code.
  jsr $0300

  sta $07FF ; Signal to simulator that we're done.
  jmp *


