  ; irq.bin
  ; * = $FD00 ; ROM
  * = $0500 ; System RAM
  ; IRQ handler

  ; BBB BB BBAAA AAAAA
  ; yyy NN YYYYY XXXXX
  ; ||| || ||||| +++++-- coarse X scroll
  ; ||| || +++++-------- coarse Y scroll
  ; ||| ++-------------- nametable select
  ; +++----------------- fine Y scroll

  ; Latch is pre-set to w=1

  ; X and A must be preserved by this interrupt handler.
  ;nop ; Even a delay of 2 cycles is enough to break the whole renderer.
  ldy #$00  ; $0500, $0501
  ; w=1
  sty $2006 ; $0502, $0503, $0504  B + commit
  ldy #$00  ; $0505, $0506
  ; w=0
  sty $2005 ; $0507, $0508, $0509  A   Patched to $2006 after first IRQ

  pha

  ldy $FF ; Scrollpoints array index

  lda $80,y ; Scrollpoints array: Scanlines delta
  sta $C000 ; MMC3 IRQ latch
  iny

  ; Patch
  lda $80,y ; Scrollpoints array: Coarse scroll Y
  sta $0501
  iny

  sty $FF

  sty $E000 ; MMC3 IRQ acknowledge + disable
  sty $E001 ; MMC3 IRQ enable

  pla
  !warn "Patchable NOP is at ",*
!if * != $0524 {
  !error "* != $0524"
}
  nop ; $0524  Patched to RTI after first IRQ

  ; MMC3: Set CHR banks for main view
  ldy #$00
  sty $8000 ; Select R0
  sty $8001 ; Set CHR bank 0 at $0000-$07FF

  iny
  sty $8000 ; Select R1
  iny
  sty $8001 ; Set CHR bank 2 at $0800-$0FFF

  ; Patch
  ldy #$00
  sty $0506
  ldy #$06
  sty $0508
  ldy #$40 ; RTI
  sty $0524

  rti
